/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationAssignmentForPrincipal;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalResponse;

public class ListApplicationAssignmentsForPrincipalPublisher
implements SdkPublisher<ListApplicationAssignmentsForPrincipalResponse> {
    private final SsoAdminAsyncClient client;
    private final ListApplicationAssignmentsForPrincipalRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationAssignmentsForPrincipalPublisher(SsoAdminAsyncClient client, ListApplicationAssignmentsForPrincipalRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationAssignmentsForPrincipalPublisher(SsoAdminAsyncClient client, ListApplicationAssignmentsForPrincipalRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationAssignmentsForPrincipalResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationAssignmentsForPrincipalResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApplicationAssignmentForPrincipal> applicationAssignments() {
        Function<ListApplicationAssignmentsForPrincipalResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationAssignments() != null) {
                return response.applicationAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationAssignmentsForPrincipalResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationAssignmentsForPrincipalResponseFetcher
    implements AsyncPageFetcher<ListApplicationAssignmentsForPrincipalResponse> {
        private ListApplicationAssignmentsForPrincipalResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationAssignmentsForPrincipalResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationAssignmentsForPrincipalResponse> nextPage(ListApplicationAssignmentsForPrincipalResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAssignmentsForPrincipalPublisher.this.client.listApplicationAssignmentsForPrincipal(ListApplicationAssignmentsForPrincipalPublisher.this.firstRequest);
            }
            return ListApplicationAssignmentsForPrincipalPublisher.this.client.listApplicationAssignmentsForPrincipal((ListApplicationAssignmentsForPrincipalRequest)((Object)ListApplicationAssignmentsForPrincipalPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

