/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerConfiguration;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustedTokenIssuerResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, DescribeTrustedTokenIssuerResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeTrustedTokenIssuerResponse.getter(DescribeTrustedTokenIssuerResponse::name)).setter(DescribeTrustedTokenIssuerResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustedTokenIssuerArn").getter(DescribeTrustedTokenIssuerResponse.getter(DescribeTrustedTokenIssuerResponse::trustedTokenIssuerArn)).setter(DescribeTrustedTokenIssuerResponse.setter(Builder::trustedTokenIssuerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerArn").build()}).build();
    private static final SdkField<TrustedTokenIssuerConfiguration> TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrustedTokenIssuerConfiguration").getter(DescribeTrustedTokenIssuerResponse.getter(DescribeTrustedTokenIssuerResponse::trustedTokenIssuerConfiguration)).setter(DescribeTrustedTokenIssuerResponse.setter(Builder::trustedTokenIssuerConfiguration)).constructor(TrustedTokenIssuerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerConfiguration").build()}).build();
    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustedTokenIssuerType").getter(DescribeTrustedTokenIssuerResponse.getter(DescribeTrustedTokenIssuerResponse::trustedTokenIssuerTypeAsString)).setter(DescribeTrustedTokenIssuerResponse.setter(Builder::trustedTokenIssuerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TRUSTED_TOKEN_ISSUER_ARN_FIELD, TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD, TRUSTED_TOKEN_ISSUER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTrustedTokenIssuerResponse.memberNameToFieldInitializer();
    private final String name;
    private final String trustedTokenIssuerArn;
    private final TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration;
    private final String trustedTokenIssuerType;

    private DescribeTrustedTokenIssuerResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.trustedTokenIssuerArn = builder.trustedTokenIssuerArn;
        this.trustedTokenIssuerConfiguration = builder.trustedTokenIssuerConfiguration;
        this.trustedTokenIssuerType = builder.trustedTokenIssuerType;
    }

    public final String name() {
        return this.name;
    }

    public final String trustedTokenIssuerArn() {
        return this.trustedTokenIssuerArn;
    }

    public final TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration() {
        return this.trustedTokenIssuerConfiguration;
    }

    public final TrustedTokenIssuerType trustedTokenIssuerType() {
        return TrustedTokenIssuerType.fromValue(this.trustedTokenIssuerType);
    }

    public final String trustedTokenIssuerTypeAsString() {
        return this.trustedTokenIssuerType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedTokenIssuerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedTokenIssuerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedTokenIssuerTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedTokenIssuerResponse)) {
            return false;
        }
        DescribeTrustedTokenIssuerResponse other = (DescribeTrustedTokenIssuerResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.trustedTokenIssuerArn(), other.trustedTokenIssuerArn()) && Objects.equals(this.trustedTokenIssuerConfiguration(), other.trustedTokenIssuerConfiguration()) && Objects.equals(this.trustedTokenIssuerTypeAsString(), other.trustedTokenIssuerTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrustedTokenIssuerResponse").add("Name", (Object)this.name()).add("TrustedTokenIssuerArn", (Object)this.trustedTokenIssuerArn()).add("TrustedTokenIssuerConfiguration", (Object)this.trustedTokenIssuerConfiguration()).add("TrustedTokenIssuerType", (Object)this.trustedTokenIssuerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TrustedTokenIssuerArn": {
                return Optional.ofNullable(clazz.cast(this.trustedTokenIssuerArn()));
            }
            case "TrustedTokenIssuerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.trustedTokenIssuerConfiguration()));
            }
            case "TrustedTokenIssuerType": {
                return Optional.ofNullable(clazz.cast(this.trustedTokenIssuerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("TrustedTokenIssuerArn", TRUSTED_TOKEN_ISSUER_ARN_FIELD);
        map.put("TrustedTokenIssuerConfiguration", TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD);
        map.put("TrustedTokenIssuerType", TRUSTED_TOKEN_ISSUER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedTokenIssuerResponse, T> g) {
        return obj -> g.apply((DescribeTrustedTokenIssuerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private String name;
        private String trustedTokenIssuerArn;
        private TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration;
        private String trustedTokenIssuerType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedTokenIssuerResponse model) {
            super(model);
            this.name(model.name);
            this.trustedTokenIssuerArn(model.trustedTokenIssuerArn);
            this.trustedTokenIssuerConfiguration(model.trustedTokenIssuerConfiguration);
            this.trustedTokenIssuerType(model.trustedTokenIssuerType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrustedTokenIssuerArn() {
            return this.trustedTokenIssuerArn;
        }

        public final void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
        }

        @Override
        public final Builder trustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
            return this;
        }

        public final TrustedTokenIssuerConfiguration.Builder getTrustedTokenIssuerConfiguration() {
            return this.trustedTokenIssuerConfiguration != null ? this.trustedTokenIssuerConfiguration.toBuilder() : null;
        }

        public final void setTrustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration.BuilderImpl trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration != null ? trustedTokenIssuerConfiguration.build() : null;
        }

        @Override
        public final Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration;
            return this;
        }

        public final String getTrustedTokenIssuerType() {
            return this.trustedTokenIssuerType;
        }

        public final void setTrustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
        }

        @Override
        public final Builder trustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
            return this;
        }

        @Override
        public final Builder trustedTokenIssuerType(TrustedTokenIssuerType trustedTokenIssuerType) {
            this.trustedTokenIssuerType(trustedTokenIssuerType == null ? null : trustedTokenIssuerType.toString());
            return this;
        }

        @Override
        public DescribeTrustedTokenIssuerResponse build() {
            return new DescribeTrustedTokenIssuerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrustedTokenIssuerResponse> {
        public Builder name(String var1);

        public Builder trustedTokenIssuerArn(String var1);

        public Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration var1);

        default public Builder trustedTokenIssuerConfiguration(Consumer<TrustedTokenIssuerConfiguration.Builder> trustedTokenIssuerConfiguration) {
            return this.trustedTokenIssuerConfiguration((TrustedTokenIssuerConfiguration)((TrustedTokenIssuerConfiguration.Builder)TrustedTokenIssuerConfiguration.builder().applyMutation(trustedTokenIssuerConfiguration)).build());
        }

        public Builder trustedTokenIssuerType(String var1);

        public Builder trustedTokenIssuerType(TrustedTokenIssuerType var1);
    }
}

