/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutApplicationAssignmentConfigurationRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, PutApplicationAssignmentConfigurationRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(PutApplicationAssignmentConfigurationRequest.getter(PutApplicationAssignmentConfigurationRequest::applicationArn)).setter(PutApplicationAssignmentConfigurationRequest.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<Boolean> ASSIGNMENT_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssignmentRequired").getter(PutApplicationAssignmentConfigurationRequest.getter(PutApplicationAssignmentConfigurationRequest::assignmentRequired)).setter(PutApplicationAssignmentConfigurationRequest.setter(Builder::assignmentRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentRequired").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, ASSIGNMENT_REQUIRED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutApplicationAssignmentConfigurationRequest.memberNameToFieldInitializer();
    private final String applicationArn;
    private final Boolean assignmentRequired;

    private PutApplicationAssignmentConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.assignmentRequired = builder.assignmentRequired;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final Boolean assignmentRequired() {
        return this.assignmentRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentRequired());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationAssignmentConfigurationRequest)) {
            return false;
        }
        PutApplicationAssignmentConfigurationRequest other = (PutApplicationAssignmentConfigurationRequest)((Object)obj);
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.assignmentRequired(), other.assignmentRequired());
    }

    public final String toString() {
        return ToString.builder((String)"PutApplicationAssignmentConfigurationRequest").add("ApplicationArn", (Object)this.applicationArn()).add("AssignmentRequired", (Object)this.assignmentRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "AssignmentRequired": {
                return Optional.ofNullable(clazz.cast(this.assignmentRequired()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("AssignmentRequired", ASSIGNMENT_REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutApplicationAssignmentConfigurationRequest, T> g) {
        return obj -> g.apply((PutApplicationAssignmentConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String applicationArn;
        private Boolean assignmentRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationAssignmentConfigurationRequest model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.assignmentRequired(model.assignmentRequired);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final Boolean getAssignmentRequired() {
            return this.assignmentRequired;
        }

        public final void setAssignmentRequired(Boolean assignmentRequired) {
            this.assignmentRequired = assignmentRequired;
        }

        @Override
        public final Builder assignmentRequired(Boolean assignmentRequired) {
            this.assignmentRequired = assignmentRequired;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApplicationAssignmentConfigurationRequest build() {
            return new PutApplicationAssignmentConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutApplicationAssignmentConfigurationRequest> {
        public Builder applicationArn(String var1);

        public Builder assignmentRequired(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

