/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sso.SsoAsyncClient;
import software.amazon.awssdk.services.sso.internal.UserAgentUtils;
import software.amazon.awssdk.services.sso.model.AccountInfo;
import software.amazon.awssdk.services.sso.model.ListAccountsRequest;
import software.amazon.awssdk.services.sso.model.ListAccountsResponse;

public class ListAccountsPublisher
implements SdkPublisher<ListAccountsResponse> {
    private final SsoAsyncClient client;
    private final ListAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountsPublisher(SsoAsyncClient client, ListAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountsPublisher(SsoAsyncClient client, ListAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountInfo> accountList() {
        return this.flatMapIterable(response -> response.accountList());
    }

    private class ListAccountsResponseFetcher
    implements AsyncPageFetcher<ListAccountsResponse> {
        private ListAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountsResponse> nextPage(ListAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsPublisher.this.client.listAccounts(ListAccountsPublisher.this.firstRequest);
            }
            return ListAccountsPublisher.this.client.listAccounts((ListAccountsRequest)((Object)ListAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

