/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sso.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRoleCredentialsRequest extends SsoRequest implements
        ToCopyableBuilder<GetRoleCredentialsRequest.Builder, GetRoleCredentialsRequest> {
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleName").getter(getter(GetRoleCredentialsRequest::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("role_name").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(GetRoleCredentialsRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("account_id").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(GetRoleCredentialsRequest::accessToken))
            .setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-sso_bearer_token").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_NAME_FIELD,
            ACCOUNT_ID_FIELD, ACCESS_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String roleName;

    private final String accountId;

    private final String accessToken;

    private GetRoleCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
        this.accountId = builder.accountId;
        this.accessToken = builder.accessToken;
    }

    /**
     * <p>
     * The friendly name of the role that is assigned to the user.
     * </p>
     * 
     * @return The friendly name of the role that is assigned to the user.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The identifier for the AWS account that is assigned to the user.
     * </p>
     * 
     * @return The identifier for the AWS account that is assigned to the user.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The token issued by the <code>CreateToken</code> API call. For more information, see <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html">CreateToken</a> in
     * the <i>IAM Identity Center OIDC API Reference Guide</i>.
     * </p>
     * 
     * @return The token issued by the <code>CreateToken</code> API call. For more information, see <a
     *         href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html"
     *         >CreateToken</a> in the <i>IAM Identity Center OIDC API Reference Guide</i>.
     */
    public final String accessToken() {
        return accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRoleCredentialsRequest)) {
            return false;
        }
        GetRoleCredentialsRequest other = (GetRoleCredentialsRequest) obj;
        return Objects.equals(roleName(), other.roleName()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(accessToken(), other.accessToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRoleCredentialsRequest").add("RoleName", roleName()).add("AccountId", accountId())
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("role_name", ROLE_NAME_FIELD);
        map.put("account_id", ACCOUNT_ID_FIELD);
        map.put("x-amz-sso_bearer_token", ACCESS_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRoleCredentialsRequest, T> g) {
        return obj -> g.apply((GetRoleCredentialsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsoRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetRoleCredentialsRequest> {
        /**
         * <p>
         * The friendly name of the role that is assigned to the user.
         * </p>
         * 
         * @param roleName
         *        The friendly name of the role that is assigned to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The identifier for the AWS account that is assigned to the user.
         * </p>
         * 
         * @param accountId
         *        The identifier for the AWS account that is assigned to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The token issued by the <code>CreateToken</code> API call. For more information, see <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html">CreateToken</a>
         * in the <i>IAM Identity Center OIDC API Reference Guide</i>.
         * </p>
         * 
         * @param accessToken
         *        The token issued by the <code>CreateToken</code> API call. For more information, see <a
         *        href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html"
         *        >CreateToken</a> in the <i>IAM Identity Center OIDC API Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoRequest.BuilderImpl implements Builder {
        private String roleName;

        private String accountId;

        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRoleCredentialsRequest model) {
            super(model);
            roleName(model.roleName);
            accountId(model.accountId);
            accessToken(model.accessToken);
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRoleCredentialsRequest build() {
            return new GetRoleCredentialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
