/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.token.credentials.SdkToken;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.sso.auth.ExpiredTokenException;
import software.amazon.awssdk.services.sso.internal.SsoAccessToken;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class SsoAccessTokenProvider
implements SdkTokenProvider {
    private static final JsonNodeParser PARSER = JsonNodeParser.builder().removeErrorLocations(true).build();
    private final Path cachedTokenFilePath;

    public SsoAccessTokenProvider(Path cachedTokenFilePath) {
        this.cachedTokenFilePath = cachedTokenFilePath;
    }

    public SdkToken resolveToken() {
        return this.tokenFromFile();
    }

    private SdkToken tokenFromFile() {
        SdkToken sdkToken;
        block8: {
            InputStream cachedTokenStream = Files.newInputStream(this.cachedTokenFilePath, new OpenOption[0]);
            try {
                sdkToken = this.getTokenFromJson(IoUtils.toUtf8String((InputStream)cachedTokenStream));
                if (cachedTokenStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cachedTokenStream != null) {
                        try {
                            cachedTokenStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            cachedTokenStream.close();
        }
        return sdkToken;
    }

    private SdkToken getTokenFromJson(String json) {
        JsonNode jsonNode = PARSER.parse(json);
        String expiration = jsonNode.field("expiresAt").map(JsonNode::text).orElse(null);
        Validate.notNull((Object)expiration, (String)"The SSO session's expiration time could not be determined. Please refresh your SSO session.", (Object[])new Object[0]);
        if (this.tokenIsInvalid(expiration)) {
            throw ExpiredTokenException.builder().message("The SSO session associated with this profile has expired or is otherwise invalid. To refresh this SSO session run aws sso login with the corresponding profile.").build();
        }
        return SsoAccessToken.builder().accessToken(((JsonNode)jsonNode.asObject().get("accessToken")).text()).expiresAt(Instant.parse(expiration)).build();
    }

    private boolean tokenIsInvalid(String expirationTime) {
        return Instant.now().isAfter(Instant.parse(expirationTime));
    }
}

