/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckOperation;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckOperationListCopier;
import software.amazon.awssdk.services.ssmsap.model.SsmSapResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationCheckOperationsResponse
extends SsmSapResponse
implements ToCopyableBuilder<Builder, ListConfigurationCheckOperationsResponse> {
    private static final SdkField<List<ConfigurationCheckOperation>> CONFIGURATION_CHECK_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationCheckOperations").getter(ListConfigurationCheckOperationsResponse.getter(ListConfigurationCheckOperationsResponse::configurationCheckOperations)).setter(ListConfigurationCheckOperationsResponse.setter(Builder::configurationCheckOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationCheckOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationCheckOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationCheckOperationsResponse.getter(ListConfigurationCheckOperationsResponse::nextToken)).setter(ListConfigurationCheckOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_CHECK_OPERATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConfigurationCheckOperationsResponse.memberNameToFieldInitializer();
    private final List<ConfigurationCheckOperation> configurationCheckOperations;
    private final String nextToken;

    private ListConfigurationCheckOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationCheckOperations = builder.configurationCheckOperations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurationCheckOperations() {
        return this.configurationCheckOperations != null && !(this.configurationCheckOperations instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationCheckOperation> configurationCheckOperations() {
        return this.configurationCheckOperations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationCheckOperations() ? this.configurationCheckOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationCheckOperationsResponse)) {
            return false;
        }
        ListConfigurationCheckOperationsResponse other = (ListConfigurationCheckOperationsResponse)((Object)obj);
        return this.hasConfigurationCheckOperations() == other.hasConfigurationCheckOperations() && Objects.equals(this.configurationCheckOperations(), other.configurationCheckOperations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationCheckOperationsResponse").add("ConfigurationCheckOperations", this.hasConfigurationCheckOperations() ? this.configurationCheckOperations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationCheckOperations": {
                return Optional.ofNullable(clazz.cast(this.configurationCheckOperations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationCheckOperations", CONFIGURATION_CHECK_OPERATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationCheckOperationsResponse, T> g) {
        return obj -> g.apply((ListConfigurationCheckOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationCheckOperation> configurationCheckOperations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationCheckOperationsResponse model) {
            super(model);
            this.configurationCheckOperations(model.configurationCheckOperations);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationCheckOperation.Builder> getConfigurationCheckOperations() {
            List<ConfigurationCheckOperation.Builder> result = ConfigurationCheckOperationListCopier.copyToBuilder(this.configurationCheckOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationCheckOperations(Collection<ConfigurationCheckOperation.BuilderImpl> configurationCheckOperations) {
            this.configurationCheckOperations = ConfigurationCheckOperationListCopier.copyFromBuilder(configurationCheckOperations);
        }

        @Override
        public final Builder configurationCheckOperations(Collection<ConfigurationCheckOperation> configurationCheckOperations) {
            this.configurationCheckOperations = ConfigurationCheckOperationListCopier.copy(configurationCheckOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationCheckOperations(ConfigurationCheckOperation ... configurationCheckOperations) {
            this.configurationCheckOperations(Arrays.asList(configurationCheckOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationCheckOperations(Consumer<ConfigurationCheckOperation.Builder> ... configurationCheckOperations) {
            this.configurationCheckOperations(Stream.of(configurationCheckOperations).map(c -> (ConfigurationCheckOperation)((ConfigurationCheckOperation.Builder)ConfigurationCheckOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationCheckOperationsResponse build() {
            return new ListConfigurationCheckOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmSapResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationCheckOperationsResponse> {
        public Builder configurationCheckOperations(Collection<ConfigurationCheckOperation> var1);

        public Builder configurationCheckOperations(ConfigurationCheckOperation ... var1);

        public Builder configurationCheckOperations(Consumer<ConfigurationCheckOperation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

