/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsResponse;
import software.amazon.awssdk.services.ssmsap.model.SubCheckResult;

public class ListSubCheckResultsIterable
implements SdkIterable<ListSubCheckResultsResponse> {
    private final SsmSapClient client;
    private final ListSubCheckResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubCheckResultsIterable(SsmSapClient client, ListSubCheckResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubCheckResultsResponseFetcher();
    }

    public Iterator<ListSubCheckResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SubCheckResult> subCheckResults() {
        Function<ListSubCheckResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subCheckResults() != null) {
                return response.subCheckResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubCheckResultsResponseFetcher
    implements SyncPageFetcher<ListSubCheckResultsResponse> {
        private ListSubCheckResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubCheckResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubCheckResultsResponse nextPage(ListSubCheckResultsResponse previousPage) {
            if (previousPage == null) {
                return ListSubCheckResultsIterable.this.client.listSubCheckResults(ListSubCheckResultsIterable.this.firstRequest);
            }
            return ListSubCheckResultsIterable.this.client.listSubCheckResults((ListSubCheckResultsRequest)((Object)ListSubCheckResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

