/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckDefinition;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckDefinitionsResponse;

public class ListConfigurationCheckDefinitionsIterable
implements SdkIterable<ListConfigurationCheckDefinitionsResponse> {
    private final SsmSapClient client;
    private final ListConfigurationCheckDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationCheckDefinitionsIterable(SsmSapClient client, ListConfigurationCheckDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationCheckDefinitionsResponseFetcher();
    }

    public Iterator<ListConfigurationCheckDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationCheckDefinition> configurationChecks() {
        Function<ListConfigurationCheckDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationChecks() != null) {
                return response.configurationChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigurationCheckDefinitionsResponseFetcher
    implements SyncPageFetcher<ListConfigurationCheckDefinitionsResponse> {
        private ListConfigurationCheckDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationCheckDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationCheckDefinitionsResponse nextPage(ListConfigurationCheckDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationCheckDefinitionsIterable.this.client.listConfigurationCheckDefinitions(ListConfigurationCheckDefinitionsIterable.this.firstRequest);
            }
            return ListConfigurationCheckDefinitionsIterable.this.client.listConfigurationCheckDefinitions((ListConfigurationCheckDefinitionsRequest)((Object)ListConfigurationCheckDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

