/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.ApplicationType;
import software.amazon.awssdk.services.ssmsap.model.ApplicationTypeListCopier;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationCheckDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationCheckDefinition> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ConfigurationCheckDefinition.getter(ConfigurationCheckDefinition::idAsString)).setter(ConfigurationCheckDefinition.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ConfigurationCheckDefinition.getter(ConfigurationCheckDefinition::name)).setter(ConfigurationCheckDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ConfigurationCheckDefinition.getter(ConfigurationCheckDefinition::description)).setter(ConfigurationCheckDefinition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> APPLICABLE_APPLICATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicableApplicationTypes").getter(ConfigurationCheckDefinition.getter(ConfigurationCheckDefinition::applicableApplicationTypesAsStrings)).setter(ConfigurationCheckDefinition.setter(Builder::applicableApplicationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicableApplicationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, APPLICABLE_APPLICATION_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationCheckDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final List<String> applicableApplicationTypes;

    private ConfigurationCheckDefinition(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.applicableApplicationTypes = builder.applicableApplicationTypes;
    }

    public final ConfigurationCheckType id() {
        return ConfigurationCheckType.fromValue(this.id);
    }

    public final String idAsString() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final List<ApplicationType> applicableApplicationTypes() {
        return ApplicationTypeListCopier.copyStringToEnum(this.applicableApplicationTypes);
    }

    public final boolean hasApplicableApplicationTypes() {
        return this.applicableApplicationTypes != null && !(this.applicableApplicationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> applicableApplicationTypesAsStrings() {
        return this.applicableApplicationTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.idAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicableApplicationTypes() ? this.applicableApplicationTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationCheckDefinition)) {
            return false;
        }
        ConfigurationCheckDefinition other = (ConfigurationCheckDefinition)obj;
        return Objects.equals(this.idAsString(), other.idAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasApplicableApplicationTypes() == other.hasApplicableApplicationTypes() && Objects.equals(this.applicableApplicationTypesAsStrings(), other.applicableApplicationTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationCheckDefinition").add("Id", (Object)this.idAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ApplicableApplicationTypes", this.hasApplicableApplicationTypes() ? this.applicableApplicationTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.idAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ApplicableApplicationTypes": {
                return Optional.ofNullable(clazz.cast(this.applicableApplicationTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ApplicableApplicationTypes", APPLICABLE_APPLICATION_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationCheckDefinition, T> g) {
        return obj -> g.apply((ConfigurationCheckDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private List<String> applicableApplicationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationCheckDefinition model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.applicableApplicationTypesWithStrings(model.applicableApplicationTypes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public final Builder id(ConfigurationCheckType id) {
            this.id(id == null ? null : id.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getApplicableApplicationTypes() {
            if (this.applicableApplicationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicableApplicationTypes;
        }

        public final void setApplicableApplicationTypes(Collection<String> applicableApplicationTypes) {
            this.applicableApplicationTypes = ApplicationTypeListCopier.copy(applicableApplicationTypes);
        }

        @Override
        public final Builder applicableApplicationTypesWithStrings(Collection<String> applicableApplicationTypes) {
            this.applicableApplicationTypes = ApplicationTypeListCopier.copy(applicableApplicationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableApplicationTypesWithStrings(String ... applicableApplicationTypes) {
            this.applicableApplicationTypesWithStrings(Arrays.asList(applicableApplicationTypes));
            return this;
        }

        @Override
        public final Builder applicableApplicationTypes(Collection<ApplicationType> applicableApplicationTypes) {
            this.applicableApplicationTypes = ApplicationTypeListCopier.copyEnumToString(applicableApplicationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableApplicationTypes(ApplicationType ... applicableApplicationTypes) {
            this.applicableApplicationTypes(Arrays.asList(applicableApplicationTypes));
            return this;
        }

        public ConfigurationCheckDefinition build() {
            return new ConfigurationCheckDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationCheckDefinition> {
        public Builder id(String var1);

        public Builder id(ConfigurationCheckType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder applicableApplicationTypesWithStrings(Collection<String> var1);

        public Builder applicableApplicationTypesWithStrings(String ... var1);

        public Builder applicableApplicationTypes(Collection<ApplicationType> var1);

        public Builder applicableApplicationTypes(ApplicationType ... var1);
    }
}

