/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.BackintMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackintConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackintConfig> {
    private static final SdkField<String> BACKINT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackintMode").getter(BackintConfig.getter(BackintConfig::backintModeAsString)).setter(BackintConfig.setter(Builder::backintMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackintMode").build()}).build();
    private static final SdkField<Boolean> ENSURE_NO_BACKUP_IN_PROCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnsureNoBackupInProcess").getter(BackintConfig.getter(BackintConfig::ensureNoBackupInProcess)).setter(BackintConfig.setter(Builder::ensureNoBackupInProcess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnsureNoBackupInProcess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKINT_MODE_FIELD, ENSURE_NO_BACKUP_IN_PROCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BackintConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String backintMode;
    private final Boolean ensureNoBackupInProcess;

    private BackintConfig(BuilderImpl builder) {
        this.backintMode = builder.backintMode;
        this.ensureNoBackupInProcess = builder.ensureNoBackupInProcess;
    }

    public final BackintMode backintMode() {
        return BackintMode.fromValue(this.backintMode);
    }

    public final String backintModeAsString() {
        return this.backintMode;
    }

    public final Boolean ensureNoBackupInProcess() {
        return this.ensureNoBackupInProcess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backintModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ensureNoBackupInProcess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackintConfig)) {
            return false;
        }
        BackintConfig other = (BackintConfig)obj;
        return Objects.equals(this.backintModeAsString(), other.backintModeAsString()) && Objects.equals(this.ensureNoBackupInProcess(), other.ensureNoBackupInProcess());
    }

    public final String toString() {
        return ToString.builder((String)"BackintConfig").add("BackintMode", (Object)this.backintModeAsString()).add("EnsureNoBackupInProcess", (Object)this.ensureNoBackupInProcess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackintMode": {
                return Optional.ofNullable(clazz.cast(this.backintModeAsString()));
            }
            case "EnsureNoBackupInProcess": {
                return Optional.ofNullable(clazz.cast(this.ensureNoBackupInProcess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackintMode", BACKINT_MODE_FIELD);
        map.put("EnsureNoBackupInProcess", ENSURE_NO_BACKUP_IN_PROCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackintConfig, T> g) {
        return obj -> g.apply((BackintConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backintMode;
        private Boolean ensureNoBackupInProcess;

        private BuilderImpl() {
        }

        private BuilderImpl(BackintConfig model) {
            this.backintMode(model.backintMode);
            this.ensureNoBackupInProcess(model.ensureNoBackupInProcess);
        }

        public final String getBackintMode() {
            return this.backintMode;
        }

        public final void setBackintMode(String backintMode) {
            this.backintMode = backintMode;
        }

        @Override
        public final Builder backintMode(String backintMode) {
            this.backintMode = backintMode;
            return this;
        }

        @Override
        public final Builder backintMode(BackintMode backintMode) {
            this.backintMode(backintMode == null ? null : backintMode.toString());
            return this;
        }

        public final Boolean getEnsureNoBackupInProcess() {
            return this.ensureNoBackupInProcess;
        }

        public final void setEnsureNoBackupInProcess(Boolean ensureNoBackupInProcess) {
            this.ensureNoBackupInProcess = ensureNoBackupInProcess;
        }

        @Override
        public final Builder ensureNoBackupInProcess(Boolean ensureNoBackupInProcess) {
            this.ensureNoBackupInProcess = ensureNoBackupInProcess;
            return this;
        }

        public BackintConfig build() {
            return new BackintConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackintConfig> {
        public Builder backintMode(String var1);

        public Builder backintMode(BackintMode var1);

        public Builder ensureNoBackupInProcess(Boolean var1);
    }
}

