/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.CloudFormationStackUpdate;
import software.amazon.awssdk.services.ssmincidents.model.CodeDeployDeployment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingDetails> {
    private static final SdkField<CloudFormationStackUpdate> CLOUD_FORMATION_STACK_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudFormationStackUpdate").getter(FindingDetails.getter(FindingDetails::cloudFormationStackUpdate)).setter(FindingDetails.setter(Builder::cloudFormationStackUpdate)).constructor(CloudFormationStackUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormationStackUpdate").build()}).build();
    private static final SdkField<CodeDeployDeployment> CODE_DEPLOY_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("codeDeployDeployment").getter(FindingDetails.getter(FindingDetails::codeDeployDeployment)).setter(FindingDetails.setter(Builder::codeDeployDeployment)).constructor(CodeDeployDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeDeployDeployment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_STACK_UPDATE_FIELD, CODE_DEPLOY_DEPLOYMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CloudFormationStackUpdate cloudFormationStackUpdate;
    private final CodeDeployDeployment codeDeployDeployment;
    private final Type type;

    private FindingDetails(BuilderImpl builder) {
        this.cloudFormationStackUpdate = builder.cloudFormationStackUpdate;
        this.codeDeployDeployment = builder.codeDeployDeployment;
        this.type = builder.type;
    }

    public final CloudFormationStackUpdate cloudFormationStackUpdate() {
        return this.cloudFormationStackUpdate;
    }

    public final CodeDeployDeployment codeDeployDeployment() {
        return this.codeDeployDeployment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormationStackUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeployDeployment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingDetails)) {
            return false;
        }
        FindingDetails other = (FindingDetails)obj;
        return Objects.equals(this.cloudFormationStackUpdate(), other.cloudFormationStackUpdate()) && Objects.equals(this.codeDeployDeployment(), other.codeDeployDeployment());
    }

    public final String toString() {
        return ToString.builder((String)"FindingDetails").add("CloudFormationStackUpdate", (Object)this.cloudFormationStackUpdate()).add("CodeDeployDeployment", (Object)this.codeDeployDeployment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudFormationStackUpdate": {
                return Optional.ofNullable(clazz.cast(this.cloudFormationStackUpdate()));
            }
            case "codeDeployDeployment": {
                return Optional.ofNullable(clazz.cast(this.codeDeployDeployment()));
            }
        }
        return Optional.empty();
    }

    public static FindingDetails fromCloudFormationStackUpdate(CloudFormationStackUpdate cloudFormationStackUpdate) {
        return (FindingDetails)FindingDetails.builder().cloudFormationStackUpdate(cloudFormationStackUpdate).build();
    }

    public static FindingDetails fromCloudFormationStackUpdate(Consumer<CloudFormationStackUpdate.Builder> cloudFormationStackUpdate) {
        CloudFormationStackUpdate.Builder builder = CloudFormationStackUpdate.builder();
        cloudFormationStackUpdate.accept(builder);
        return FindingDetails.fromCloudFormationStackUpdate((CloudFormationStackUpdate)builder.build());
    }

    public static FindingDetails fromCodeDeployDeployment(CodeDeployDeployment codeDeployDeployment) {
        return (FindingDetails)FindingDetails.builder().codeDeployDeployment(codeDeployDeployment).build();
    }

    public static FindingDetails fromCodeDeployDeployment(Consumer<CodeDeployDeployment.Builder> codeDeployDeployment) {
        CodeDeployDeployment.Builder builder = CodeDeployDeployment.builder();
        codeDeployDeployment.accept(builder);
        return FindingDetails.fromCodeDeployDeployment((CodeDeployDeployment)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudFormationStackUpdate", CLOUD_FORMATION_STACK_UPDATE_FIELD);
        map.put("codeDeployDeployment", CODE_DEPLOY_DEPLOYMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingDetails, T> g) {
        return obj -> g.apply((FindingDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CLOUD_FORMATION_STACK_UPDATE,
        CODE_DEPLOY_DEPLOYMENT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CloudFormationStackUpdate cloudFormationStackUpdate;
        private CodeDeployDeployment codeDeployDeployment;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FindingDetails model) {
            this.cloudFormationStackUpdate(model.cloudFormationStackUpdate);
            this.codeDeployDeployment(model.codeDeployDeployment);
        }

        public final CloudFormationStackUpdate.Builder getCloudFormationStackUpdate() {
            return this.cloudFormationStackUpdate != null ? this.cloudFormationStackUpdate.toBuilder() : null;
        }

        public final void setCloudFormationStackUpdate(CloudFormationStackUpdate.BuilderImpl cloudFormationStackUpdate) {
            CloudFormationStackUpdate oldValue = this.cloudFormationStackUpdate;
            this.cloudFormationStackUpdate = cloudFormationStackUpdate != null ? cloudFormationStackUpdate.build() : null;
            this.handleUnionValueChange(Type.CLOUD_FORMATION_STACK_UPDATE, oldValue, this.cloudFormationStackUpdate);
        }

        @Override
        public final Builder cloudFormationStackUpdate(CloudFormationStackUpdate cloudFormationStackUpdate) {
            CloudFormationStackUpdate oldValue = this.cloudFormationStackUpdate;
            this.cloudFormationStackUpdate = cloudFormationStackUpdate;
            this.handleUnionValueChange(Type.CLOUD_FORMATION_STACK_UPDATE, oldValue, this.cloudFormationStackUpdate);
            return this;
        }

        public final CodeDeployDeployment.Builder getCodeDeployDeployment() {
            return this.codeDeployDeployment != null ? this.codeDeployDeployment.toBuilder() : null;
        }

        public final void setCodeDeployDeployment(CodeDeployDeployment.BuilderImpl codeDeployDeployment) {
            CodeDeployDeployment oldValue = this.codeDeployDeployment;
            this.codeDeployDeployment = codeDeployDeployment != null ? codeDeployDeployment.build() : null;
            this.handleUnionValueChange(Type.CODE_DEPLOY_DEPLOYMENT, oldValue, this.codeDeployDeployment);
        }

        @Override
        public final Builder codeDeployDeployment(CodeDeployDeployment codeDeployDeployment) {
            CodeDeployDeployment oldValue = this.codeDeployDeployment;
            this.codeDeployDeployment = codeDeployDeployment;
            this.handleUnionValueChange(Type.CODE_DEPLOY_DEPLOYMENT, oldValue, this.codeDeployDeployment);
            return this;
        }

        public FindingDetails build() {
            return new FindingDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingDetails> {
        public Builder cloudFormationStackUpdate(CloudFormationStackUpdate var1);

        default public Builder cloudFormationStackUpdate(Consumer<CloudFormationStackUpdate.Builder> cloudFormationStackUpdate) {
            return this.cloudFormationStackUpdate((CloudFormationStackUpdate)((CloudFormationStackUpdate.Builder)CloudFormationStackUpdate.builder().applyMutation(cloudFormationStackUpdate)).build());
        }

        public Builder codeDeployDeployment(CodeDeployDeployment var1);

        default public Builder codeDeployDeployment(Consumer<CodeDeployDeployment.Builder> codeDeployDeployment) {
            return this.codeDeployDeployment((CodeDeployDeployment)((CodeDeployDeployment.Builder)CodeDeployDeployment.builder().applyMutation(codeDeployDeployment)).build());
        }
    }
}

