/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmincidents.model.RelatedItemsUpdate;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRelatedItemsRequest
extends SsmIncidentsRequest
implements ToCopyableBuilder<Builder, UpdateRelatedItemsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateRelatedItemsRequest.getter(UpdateRelatedItemsRequest::clientToken)).setter(UpdateRelatedItemsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("incidentRecordArn").getter(UpdateRelatedItemsRequest.getter(UpdateRelatedItemsRequest::incidentRecordArn)).setter(UpdateRelatedItemsRequest.setter(Builder::incidentRecordArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordArn").build()}).build();
    private static final SdkField<RelatedItemsUpdate> RELATED_ITEMS_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("relatedItemsUpdate").getter(UpdateRelatedItemsRequest.getter(UpdateRelatedItemsRequest::relatedItemsUpdate)).setter(UpdateRelatedItemsRequest.setter(Builder::relatedItemsUpdate)).constructor(RelatedItemsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemsUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, INCIDENT_RECORD_ARN_FIELD, RELATED_ITEMS_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRelatedItemsRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String incidentRecordArn;
    private final RelatedItemsUpdate relatedItemsUpdate;

    private UpdateRelatedItemsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.incidentRecordArn = builder.incidentRecordArn;
        this.relatedItemsUpdate = builder.relatedItemsUpdate;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String incidentRecordArn() {
        return this.incidentRecordArn;
    }

    public final RelatedItemsUpdate relatedItemsUpdate() {
        return this.relatedItemsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentRecordArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedItemsUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRelatedItemsRequest)) {
            return false;
        }
        UpdateRelatedItemsRequest other = (UpdateRelatedItemsRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.incidentRecordArn(), other.incidentRecordArn()) && Objects.equals(this.relatedItemsUpdate(), other.relatedItemsUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRelatedItemsRequest").add("ClientToken", (Object)this.clientToken()).add("IncidentRecordArn", (Object)this.incidentRecordArn()).add("RelatedItemsUpdate", (Object)this.relatedItemsUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "incidentRecordArn": {
                return Optional.ofNullable(clazz.cast(this.incidentRecordArn()));
            }
            case "relatedItemsUpdate": {
                return Optional.ofNullable(clazz.cast(this.relatedItemsUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("incidentRecordArn", INCIDENT_RECORD_ARN_FIELD);
        map.put("relatedItemsUpdate", RELATED_ITEMS_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRelatedItemsRequest, T> g) {
        return obj -> g.apply((UpdateRelatedItemsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String incidentRecordArn;
        private RelatedItemsUpdate relatedItemsUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRelatedItemsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.incidentRecordArn(model.incidentRecordArn);
            this.relatedItemsUpdate(model.relatedItemsUpdate);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIncidentRecordArn() {
            return this.incidentRecordArn;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        public final RelatedItemsUpdate.Builder getRelatedItemsUpdate() {
            return this.relatedItemsUpdate != null ? this.relatedItemsUpdate.toBuilder() : null;
        }

        public final void setRelatedItemsUpdate(RelatedItemsUpdate.BuilderImpl relatedItemsUpdate) {
            this.relatedItemsUpdate = relatedItemsUpdate != null ? relatedItemsUpdate.build() : null;
        }

        @Override
        public final Builder relatedItemsUpdate(RelatedItemsUpdate relatedItemsUpdate) {
            this.relatedItemsUpdate = relatedItemsUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRelatedItemsRequest build() {
            return new UpdateRelatedItemsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmIncidentsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRelatedItemsRequest> {
        public Builder clientToken(String var1);

        public Builder incidentRecordArn(String var1);

        public Builder relatedItemsUpdate(RelatedItemsUpdate var1);

        default public Builder relatedItemsUpdate(Consumer<RelatedItemsUpdate.Builder> relatedItemsUpdate) {
            return this.relatedItemsUpdate((RelatedItemsUpdate)((RelatedItemsUpdate.Builder)RelatedItemsUpdate.builder().applyMutation(relatedItemsUpdate)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

