/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.ItemIdentifier;
import software.amazon.awssdk.services.ssmincidents.model.RelatedItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedItemsUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedItemsUpdate> {
    private static final SdkField<RelatedItem> ITEM_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("itemToAdd").getter(RelatedItemsUpdate.getter(RelatedItemsUpdate::itemToAdd)).setter(RelatedItemsUpdate.setter(Builder::itemToAdd)).constructor(RelatedItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemToAdd").build()}).build();
    private static final SdkField<ItemIdentifier> ITEM_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("itemToRemove").getter(RelatedItemsUpdate.getter(RelatedItemsUpdate::itemToRemove)).setter(RelatedItemsUpdate.setter(Builder::itemToRemove)).constructor(ItemIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemToRemove").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_TO_ADD_FIELD, ITEM_TO_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelatedItemsUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RelatedItem itemToAdd;
    private final ItemIdentifier itemToRemove;
    private final Type type;

    private RelatedItemsUpdate(BuilderImpl builder) {
        this.itemToAdd = builder.itemToAdd;
        this.itemToRemove = builder.itemToRemove;
        this.type = builder.type;
    }

    public final RelatedItem itemToAdd() {
        return this.itemToAdd;
    }

    public final ItemIdentifier itemToRemove() {
        return this.itemToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.itemToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemToRemove());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemsUpdate)) {
            return false;
        }
        RelatedItemsUpdate other = (RelatedItemsUpdate)obj;
        return Objects.equals(this.itemToAdd(), other.itemToAdd()) && Objects.equals(this.itemToRemove(), other.itemToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"RelatedItemsUpdate").add("ItemToAdd", (Object)this.itemToAdd()).add("ItemToRemove", (Object)this.itemToRemove()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemToAdd": {
                return Optional.ofNullable(clazz.cast(this.itemToAdd()));
            }
            case "itemToRemove": {
                return Optional.ofNullable(clazz.cast(this.itemToRemove()));
            }
        }
        return Optional.empty();
    }

    public static RelatedItemsUpdate fromItemToAdd(RelatedItem itemToAdd) {
        return (RelatedItemsUpdate)RelatedItemsUpdate.builder().itemToAdd(itemToAdd).build();
    }

    public static RelatedItemsUpdate fromItemToAdd(Consumer<RelatedItem.Builder> itemToAdd) {
        RelatedItem.Builder builder = RelatedItem.builder();
        itemToAdd.accept(builder);
        return RelatedItemsUpdate.fromItemToAdd((RelatedItem)builder.build());
    }

    public static RelatedItemsUpdate fromItemToRemove(ItemIdentifier itemToRemove) {
        return (RelatedItemsUpdate)RelatedItemsUpdate.builder().itemToRemove(itemToRemove).build();
    }

    public static RelatedItemsUpdate fromItemToRemove(Consumer<ItemIdentifier.Builder> itemToRemove) {
        ItemIdentifier.Builder builder = ItemIdentifier.builder();
        itemToRemove.accept(builder);
        return RelatedItemsUpdate.fromItemToRemove((ItemIdentifier)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("itemToAdd", ITEM_TO_ADD_FIELD);
        map.put("itemToRemove", ITEM_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemsUpdate, T> g) {
        return obj -> g.apply((RelatedItemsUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ITEM_TO_ADD,
        ITEM_TO_REMOVE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RelatedItem itemToAdd;
        private ItemIdentifier itemToRemove;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemsUpdate model) {
            this.itemToAdd(model.itemToAdd);
            this.itemToRemove(model.itemToRemove);
        }

        public final RelatedItem.Builder getItemToAdd() {
            return this.itemToAdd != null ? this.itemToAdd.toBuilder() : null;
        }

        public final void setItemToAdd(RelatedItem.BuilderImpl itemToAdd) {
            RelatedItem oldValue = this.itemToAdd;
            this.itemToAdd = itemToAdd != null ? itemToAdd.build() : null;
            this.handleUnionValueChange(Type.ITEM_TO_ADD, oldValue, this.itemToAdd);
        }

        @Override
        public final Builder itemToAdd(RelatedItem itemToAdd) {
            RelatedItem oldValue = this.itemToAdd;
            this.itemToAdd = itemToAdd;
            this.handleUnionValueChange(Type.ITEM_TO_ADD, oldValue, this.itemToAdd);
            return this;
        }

        public final ItemIdentifier.Builder getItemToRemove() {
            return this.itemToRemove != null ? this.itemToRemove.toBuilder() : null;
        }

        public final void setItemToRemove(ItemIdentifier.BuilderImpl itemToRemove) {
            ItemIdentifier oldValue = this.itemToRemove;
            this.itemToRemove = itemToRemove != null ? itemToRemove.build() : null;
            this.handleUnionValueChange(Type.ITEM_TO_REMOVE, oldValue, this.itemToRemove);
        }

        @Override
        public final Builder itemToRemove(ItemIdentifier itemToRemove) {
            ItemIdentifier oldValue = this.itemToRemove;
            this.itemToRemove = itemToRemove;
            this.handleUnionValueChange(Type.ITEM_TO_REMOVE, oldValue, this.itemToRemove);
            return this;
        }

        public RelatedItemsUpdate build() {
            return new RelatedItemsUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedItemsUpdate> {
        public Builder itemToAdd(RelatedItem var1);

        default public Builder itemToAdd(Consumer<RelatedItem.Builder> itemToAdd) {
            return this.itemToAdd((RelatedItem)((RelatedItem.Builder)RelatedItem.builder().applyMutation(itemToAdd)).build());
        }

        public Builder itemToRemove(ItemIdentifier var1);

        default public Builder itemToRemove(Consumer<ItemIdentifier.Builder> itemToRemove) {
            return this.itemToRemove((ItemIdentifier)((ItemIdentifier.Builder)ItemIdentifier.builder().applyMutation(itemToRemove)).build());
        }
    }
}

