/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.ContactChannelAddress;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContactChannelRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, UpdateContactChannelRequest> {
    private static final SdkField<String> CONTACT_CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactChannelId").getter(UpdateContactChannelRequest.getter(UpdateContactChannelRequest::contactChannelId)).setter(UpdateContactChannelRequest.setter(Builder::contactChannelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateContactChannelRequest.getter(UpdateContactChannelRequest::name)).setter(UpdateContactChannelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ContactChannelAddress> DELIVERY_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryAddress").getter(UpdateContactChannelRequest.getter(UpdateContactChannelRequest::deliveryAddress)).setter(UpdateContactChannelRequest.setter(Builder::deliveryAddress)).constructor(ContactChannelAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_CHANNEL_ID_FIELD, NAME_FIELD, DELIVERY_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateContactChannelRequest.memberNameToFieldInitializer();
    private final String contactChannelId;
    private final String name;
    private final ContactChannelAddress deliveryAddress;

    private UpdateContactChannelRequest(BuilderImpl builder) {
        super(builder);
        this.contactChannelId = builder.contactChannelId;
        this.name = builder.name;
        this.deliveryAddress = builder.deliveryAddress;
    }

    public final String contactChannelId() {
        return this.contactChannelId;
    }

    public final String name() {
        return this.name;
    }

    public final ContactChannelAddress deliveryAddress() {
        return this.deliveryAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactChannelRequest)) {
            return false;
        }
        UpdateContactChannelRequest other = (UpdateContactChannelRequest)((Object)obj);
        return Objects.equals(this.contactChannelId(), other.contactChannelId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.deliveryAddress(), other.deliveryAddress());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContactChannelRequest").add("ContactChannelId", (Object)this.contactChannelId()).add("Name", (Object)this.name()).add("DeliveryAddress", (Object)this.deliveryAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactChannelId": {
                return Optional.ofNullable(clazz.cast(this.contactChannelId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DeliveryAddress": {
                return Optional.ofNullable(clazz.cast(this.deliveryAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContactChannelId", CONTACT_CHANNEL_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DeliveryAddress", DELIVERY_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactChannelRequest, T> g) {
        return obj -> g.apply((UpdateContactChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String contactChannelId;
        private String name;
        private ContactChannelAddress deliveryAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactChannelRequest model) {
            super(model);
            this.contactChannelId(model.contactChannelId);
            this.name(model.name);
            this.deliveryAddress(model.deliveryAddress);
        }

        public final String getContactChannelId() {
            return this.contactChannelId;
        }

        public final void setContactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
        }

        @Override
        public final Builder contactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ContactChannelAddress.Builder getDeliveryAddress() {
            return this.deliveryAddress != null ? this.deliveryAddress.toBuilder() : null;
        }

        public final void setDeliveryAddress(ContactChannelAddress.BuilderImpl deliveryAddress) {
            this.deliveryAddress = deliveryAddress != null ? deliveryAddress.build() : null;
        }

        @Override
        public final Builder deliveryAddress(ContactChannelAddress deliveryAddress) {
            this.deliveryAddress = deliveryAddress;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactChannelRequest build() {
            return new UpdateContactChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContactChannelRequest> {
        public Builder contactChannelId(String var1);

        public Builder name(String var1);

        public Builder deliveryAddress(ContactChannelAddress var1);

        default public Builder deliveryAddress(Consumer<ContactChannelAddress.Builder> deliveryAddress) {
            return this.deliveryAddress((ContactChannelAddress)((ContactChannelAddress.Builder)ContactChannelAddress.builder().applyMutation(deliveryAddress)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

