/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmcontacts.model.CoverageTime;
import software.amazon.awssdk.services.ssmcontacts.model.DailySettingsCopier;
import software.amazon.awssdk.services.ssmcontacts.model.DayOfWeek;
import software.amazon.awssdk.services.ssmcontacts.model.HandOffTime;
import software.amazon.awssdk.services.ssmcontacts.model.MonthlySetting;
import software.amazon.awssdk.services.ssmcontacts.model.MonthlySettingsCopier;
import software.amazon.awssdk.services.ssmcontacts.model.ShiftCoveragesMapCopier;
import software.amazon.awssdk.services.ssmcontacts.model.WeeklySetting;
import software.amazon.awssdk.services.ssmcontacts.model.WeeklySettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecurrenceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecurrenceSettings> {
    private static final SdkField<List<MonthlySetting>> MONTHLY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonthlySettings").getter(RecurrenceSettings.getter(RecurrenceSettings::monthlySettings)).setter(RecurrenceSettings.setter(Builder::monthlySettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlySettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonthlySetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WeeklySetting>> WEEKLY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WeeklySettings").getter(RecurrenceSettings.getter(RecurrenceSettings::weeklySettings)).setter(RecurrenceSettings.setter(Builder::weeklySettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklySettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WeeklySetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HandOffTime>> DAILY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DailySettings").getter(RecurrenceSettings.getter(RecurrenceSettings::dailySettings)).setter(RecurrenceSettings.setter(Builder::dailySettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailySettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HandOffTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ON_CALLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfOnCalls").getter(RecurrenceSettings.getter(RecurrenceSettings::numberOfOnCalls)).setter(RecurrenceSettings.setter(Builder::numberOfOnCalls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfOnCalls").build()}).build();
    private static final SdkField<Map<String, List<CoverageTime>>> SHIFT_COVERAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ShiftCoverages").getter(RecurrenceSettings.getter(RecurrenceSettings::shiftCoveragesAsStrings)).setter(RecurrenceSettings.setter(Builder::shiftCoveragesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShiftCoverages").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoverageTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> RECURRENCE_MULTIPLIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RecurrenceMultiplier").getter(RecurrenceSettings.getter(RecurrenceSettings::recurrenceMultiplier)).setter(RecurrenceSettings.setter(Builder::recurrenceMultiplier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurrenceMultiplier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTHLY_SETTINGS_FIELD, WEEKLY_SETTINGS_FIELD, DAILY_SETTINGS_FIELD, NUMBER_OF_ON_CALLS_FIELD, SHIFT_COVERAGES_FIELD, RECURRENCE_MULTIPLIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecurrenceSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MonthlySetting> monthlySettings;
    private final List<WeeklySetting> weeklySettings;
    private final List<HandOffTime> dailySettings;
    private final Integer numberOfOnCalls;
    private final Map<String, List<CoverageTime>> shiftCoverages;
    private final Integer recurrenceMultiplier;

    private RecurrenceSettings(BuilderImpl builder) {
        this.monthlySettings = builder.monthlySettings;
        this.weeklySettings = builder.weeklySettings;
        this.dailySettings = builder.dailySettings;
        this.numberOfOnCalls = builder.numberOfOnCalls;
        this.shiftCoverages = builder.shiftCoverages;
        this.recurrenceMultiplier = builder.recurrenceMultiplier;
    }

    public final boolean hasMonthlySettings() {
        return this.monthlySettings != null && !(this.monthlySettings instanceof SdkAutoConstructList);
    }

    public final List<MonthlySetting> monthlySettings() {
        return this.monthlySettings;
    }

    public final boolean hasWeeklySettings() {
        return this.weeklySettings != null && !(this.weeklySettings instanceof SdkAutoConstructList);
    }

    public final List<WeeklySetting> weeklySettings() {
        return this.weeklySettings;
    }

    public final boolean hasDailySettings() {
        return this.dailySettings != null && !(this.dailySettings instanceof SdkAutoConstructList);
    }

    public final List<HandOffTime> dailySettings() {
        return this.dailySettings;
    }

    public final Integer numberOfOnCalls() {
        return this.numberOfOnCalls;
    }

    public final Map<DayOfWeek, List<CoverageTime>> shiftCoverages() {
        return ShiftCoveragesMapCopier.copyStringToEnum(this.shiftCoverages);
    }

    public final boolean hasShiftCoverages() {
        return this.shiftCoverages != null && !(this.shiftCoverages instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<CoverageTime>> shiftCoveragesAsStrings() {
        return this.shiftCoverages;
    }

    public final Integer recurrenceMultiplier() {
        return this.recurrenceMultiplier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonthlySettings() ? this.monthlySettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWeeklySettings() ? this.weeklySettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDailySettings() ? this.dailySettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfOnCalls());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShiftCoverages() ? this.shiftCoveragesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrenceMultiplier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurrenceSettings)) {
            return false;
        }
        RecurrenceSettings other = (RecurrenceSettings)obj;
        return this.hasMonthlySettings() == other.hasMonthlySettings() && Objects.equals(this.monthlySettings(), other.monthlySettings()) && this.hasWeeklySettings() == other.hasWeeklySettings() && Objects.equals(this.weeklySettings(), other.weeklySettings()) && this.hasDailySettings() == other.hasDailySettings() && Objects.equals(this.dailySettings(), other.dailySettings()) && Objects.equals(this.numberOfOnCalls(), other.numberOfOnCalls()) && this.hasShiftCoverages() == other.hasShiftCoverages() && Objects.equals(this.shiftCoveragesAsStrings(), other.shiftCoveragesAsStrings()) && Objects.equals(this.recurrenceMultiplier(), other.recurrenceMultiplier());
    }

    public final String toString() {
        return ToString.builder((String)"RecurrenceSettings").add("MonthlySettings", this.hasMonthlySettings() ? this.monthlySettings() : null).add("WeeklySettings", this.hasWeeklySettings() ? this.weeklySettings() : null).add("DailySettings", this.hasDailySettings() ? this.dailySettings() : null).add("NumberOfOnCalls", (Object)this.numberOfOnCalls()).add("ShiftCoverages", this.hasShiftCoverages() ? this.shiftCoveragesAsStrings() : null).add("RecurrenceMultiplier", (Object)this.recurrenceMultiplier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonthlySettings": {
                return Optional.ofNullable(clazz.cast(this.monthlySettings()));
            }
            case "WeeklySettings": {
                return Optional.ofNullable(clazz.cast(this.weeklySettings()));
            }
            case "DailySettings": {
                return Optional.ofNullable(clazz.cast(this.dailySettings()));
            }
            case "NumberOfOnCalls": {
                return Optional.ofNullable(clazz.cast(this.numberOfOnCalls()));
            }
            case "ShiftCoverages": {
                return Optional.ofNullable(clazz.cast(this.shiftCoveragesAsStrings()));
            }
            case "RecurrenceMultiplier": {
                return Optional.ofNullable(clazz.cast(this.recurrenceMultiplier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MonthlySettings", MONTHLY_SETTINGS_FIELD);
        map.put("WeeklySettings", WEEKLY_SETTINGS_FIELD);
        map.put("DailySettings", DAILY_SETTINGS_FIELD);
        map.put("NumberOfOnCalls", NUMBER_OF_ON_CALLS_FIELD);
        map.put("ShiftCoverages", SHIFT_COVERAGES_FIELD);
        map.put("RecurrenceMultiplier", RECURRENCE_MULTIPLIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecurrenceSettings, T> g) {
        return obj -> g.apply((RecurrenceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MonthlySetting> monthlySettings = DefaultSdkAutoConstructList.getInstance();
        private List<WeeklySetting> weeklySettings = DefaultSdkAutoConstructList.getInstance();
        private List<HandOffTime> dailySettings = DefaultSdkAutoConstructList.getInstance();
        private Integer numberOfOnCalls;
        private Map<String, List<CoverageTime>> shiftCoverages = DefaultSdkAutoConstructMap.getInstance();
        private Integer recurrenceMultiplier;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurrenceSettings model) {
            this.monthlySettings(model.monthlySettings);
            this.weeklySettings(model.weeklySettings);
            this.dailySettings(model.dailySettings);
            this.numberOfOnCalls(model.numberOfOnCalls);
            this.shiftCoveragesWithStrings(model.shiftCoverages);
            this.recurrenceMultiplier(model.recurrenceMultiplier);
        }

        public final List<MonthlySetting.Builder> getMonthlySettings() {
            List<MonthlySetting.Builder> result = MonthlySettingsCopier.copyToBuilder(this.monthlySettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonthlySettings(Collection<MonthlySetting.BuilderImpl> monthlySettings) {
            this.monthlySettings = MonthlySettingsCopier.copyFromBuilder(monthlySettings);
        }

        @Override
        public final Builder monthlySettings(Collection<MonthlySetting> monthlySettings) {
            this.monthlySettings = MonthlySettingsCopier.copy(monthlySettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monthlySettings(MonthlySetting ... monthlySettings) {
            this.monthlySettings(Arrays.asList(monthlySettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monthlySettings(Consumer<MonthlySetting.Builder> ... monthlySettings) {
            this.monthlySettings(Stream.of(monthlySettings).map(c -> (MonthlySetting)((MonthlySetting.Builder)MonthlySetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WeeklySetting.Builder> getWeeklySettings() {
            List<WeeklySetting.Builder> result = WeeklySettingsCopier.copyToBuilder(this.weeklySettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWeeklySettings(Collection<WeeklySetting.BuilderImpl> weeklySettings) {
            this.weeklySettings = WeeklySettingsCopier.copyFromBuilder(weeklySettings);
        }

        @Override
        public final Builder weeklySettings(Collection<WeeklySetting> weeklySettings) {
            this.weeklySettings = WeeklySettingsCopier.copy(weeklySettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weeklySettings(WeeklySetting ... weeklySettings) {
            this.weeklySettings(Arrays.asList(weeklySettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weeklySettings(Consumer<WeeklySetting.Builder> ... weeklySettings) {
            this.weeklySettings(Stream.of(weeklySettings).map(c -> (WeeklySetting)((WeeklySetting.Builder)WeeklySetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HandOffTime.Builder> getDailySettings() {
            List<HandOffTime.Builder> result = DailySettingsCopier.copyToBuilder(this.dailySettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDailySettings(Collection<HandOffTime.BuilderImpl> dailySettings) {
            this.dailySettings = DailySettingsCopier.copyFromBuilder(dailySettings);
        }

        @Override
        public final Builder dailySettings(Collection<HandOffTime> dailySettings) {
            this.dailySettings = DailySettingsCopier.copy(dailySettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dailySettings(HandOffTime ... dailySettings) {
            this.dailySettings(Arrays.asList(dailySettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dailySettings(Consumer<HandOffTime.Builder> ... dailySettings) {
            this.dailySettings(Stream.of(dailySettings).map(c -> (HandOffTime)((HandOffTime.Builder)HandOffTime.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getNumberOfOnCalls() {
            return this.numberOfOnCalls;
        }

        public final void setNumberOfOnCalls(Integer numberOfOnCalls) {
            this.numberOfOnCalls = numberOfOnCalls;
        }

        @Override
        public final Builder numberOfOnCalls(Integer numberOfOnCalls) {
            this.numberOfOnCalls = numberOfOnCalls;
            return this;
        }

        public final Map<String, List<CoverageTime.Builder>> getShiftCoverages() {
            Map<String, List<CoverageTime.Builder>> result = ShiftCoveragesMapCopier.copyToBuilder(this.shiftCoverages);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setShiftCoverages(Map<String, ? extends Collection<CoverageTime.BuilderImpl>> shiftCoverages) {
            this.shiftCoverages = ShiftCoveragesMapCopier.copyFromBuilder(shiftCoverages);
        }

        @Override
        public final Builder shiftCoveragesWithStrings(Map<String, ? extends Collection<CoverageTime>> shiftCoverages) {
            this.shiftCoverages = ShiftCoveragesMapCopier.copy(shiftCoverages);
            return this;
        }

        @Override
        public final Builder shiftCoverages(Map<DayOfWeek, ? extends Collection<CoverageTime>> shiftCoverages) {
            this.shiftCoverages = ShiftCoveragesMapCopier.copyEnumToString(shiftCoverages);
            return this;
        }

        public final Integer getRecurrenceMultiplier() {
            return this.recurrenceMultiplier;
        }

        public final void setRecurrenceMultiplier(Integer recurrenceMultiplier) {
            this.recurrenceMultiplier = recurrenceMultiplier;
        }

        @Override
        public final Builder recurrenceMultiplier(Integer recurrenceMultiplier) {
            this.recurrenceMultiplier = recurrenceMultiplier;
            return this;
        }

        public RecurrenceSettings build() {
            return new RecurrenceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecurrenceSettings> {
        public Builder monthlySettings(Collection<MonthlySetting> var1);

        public Builder monthlySettings(MonthlySetting ... var1);

        public Builder monthlySettings(Consumer<MonthlySetting.Builder> ... var1);

        public Builder weeklySettings(Collection<WeeklySetting> var1);

        public Builder weeklySettings(WeeklySetting ... var1);

        public Builder weeklySettings(Consumer<WeeklySetting.Builder> ... var1);

        public Builder dailySettings(Collection<HandOffTime> var1);

        public Builder dailySettings(HandOffTime ... var1);

        public Builder dailySettings(Consumer<HandOffTime.Builder> ... var1);

        public Builder numberOfOnCalls(Integer var1);

        public Builder shiftCoveragesWithStrings(Map<String, ? extends Collection<CoverageTime>> var1);

        public Builder shiftCoverages(Map<DayOfWeek, ? extends Collection<CoverageTime>> var1);

        public Builder recurrenceMultiplier(Integer var1);
    }
}

