/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.RotationOverridePreviewMemberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PreviewOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PreviewOverride> {
    private static final SdkField<List<String>> NEW_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NewMembers").getter(PreviewOverride.getter(PreviewOverride::newMembers)).setter(PreviewOverride.setter(Builder::newMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(PreviewOverride.getter(PreviewOverride::startTime)).setter(PreviewOverride.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(PreviewOverride.getter(PreviewOverride::endTime)).setter(PreviewOverride.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_MEMBERS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PreviewOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> newMembers;
    private final Instant startTime;
    private final Instant endTime;

    private PreviewOverride(BuilderImpl builder) {
        this.newMembers = builder.newMembers;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final boolean hasNewMembers() {
        return this.newMembers != null && !(this.newMembers instanceof SdkAutoConstructList);
    }

    public final List<String> newMembers() {
        return this.newMembers;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewMembers() ? this.newMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewOverride)) {
            return false;
        }
        PreviewOverride other = (PreviewOverride)obj;
        return this.hasNewMembers() == other.hasNewMembers() && Objects.equals(this.newMembers(), other.newMembers()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"PreviewOverride").add("NewMembers", this.hasNewMembers() ? this.newMembers() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NewMembers": {
                return Optional.ofNullable(clazz.cast(this.newMembers()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NewMembers", NEW_MEMBERS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreviewOverride, T> g) {
        return obj -> g.apply((PreviewOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> newMembers = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PreviewOverride model) {
            this.newMembers(model.newMembers);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final Collection<String> getNewMembers() {
            if (this.newMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.newMembers;
        }

        public final void setNewMembers(Collection<String> newMembers) {
            this.newMembers = RotationOverridePreviewMemberListCopier.copy(newMembers);
        }

        @Override
        public final Builder newMembers(Collection<String> newMembers) {
            this.newMembers = RotationOverridePreviewMemberListCopier.copy(newMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newMembers(String ... newMembers) {
            this.newMembers(Arrays.asList(newMembers));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public PreviewOverride build() {
            return new PreviewOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PreviewOverride> {
        public Builder newMembers(Collection<String> var1);

        public Builder newMembers(String ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

