/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity;

public class DescribeMaintenanceWindowExecutionTasksPublisher
implements SdkPublisher<DescribeMaintenanceWindowExecutionTasksResponse> {
    private final SsmAsyncClient client;
    private final DescribeMaintenanceWindowExecutionTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMaintenanceWindowExecutionTasksPublisher(SsmAsyncClient client, DescribeMaintenanceWindowExecutionTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMaintenanceWindowExecutionTasksPublisher(SsmAsyncClient client, DescribeMaintenanceWindowExecutionTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMaintenanceWindowExecutionTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMaintenanceWindowExecutionTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities() {
        return this.flatMapIterable(response -> response.windowExecutionTaskIdentities());
    }

    private class DescribeMaintenanceWindowExecutionTasksResponseFetcher
    implements AsyncPageFetcher<DescribeMaintenanceWindowExecutionTasksResponse> {
        private DescribeMaintenanceWindowExecutionTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowExecutionTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMaintenanceWindowExecutionTasksResponse> nextPage(DescribeMaintenanceWindowExecutionTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowExecutionTasksPublisher.this.client.describeMaintenanceWindowExecutionTasks(DescribeMaintenanceWindowExecutionTasksPublisher.this.firstRequest);
            }
            return DescribeMaintenanceWindowExecutionTasksPublisher.this.client.describeMaintenanceWindowExecutionTasks((DescribeMaintenanceWindowExecutionTasksRequest)((Object)DescribeMaintenanceWindowExecutionTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

