/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse;
import software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem;

public class DescribeInventoryDeletionsPublisher
implements SdkPublisher<DescribeInventoryDeletionsResponse> {
    private final SsmAsyncClient client;
    private final DescribeInventoryDeletionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInventoryDeletionsPublisher(SsmAsyncClient client, DescribeInventoryDeletionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInventoryDeletionsPublisher(SsmAsyncClient client, DescribeInventoryDeletionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInventoryDeletionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInventoryDeletionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InventoryDeletionStatusItem> inventoryDeletions() {
        return this.flatMapIterable(response -> response.inventoryDeletions());
    }

    private class DescribeInventoryDeletionsResponseFetcher
    implements AsyncPageFetcher<DescribeInventoryDeletionsResponse> {
        private DescribeInventoryDeletionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInventoryDeletionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInventoryDeletionsResponse> nextPage(DescribeInventoryDeletionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInventoryDeletionsPublisher.this.client.describeInventoryDeletions(DescribeInventoryDeletionsPublisher.this.firstRequest);
            }
            return DescribeInventoryDeletionsPublisher.this.client.describeInventoryDeletions((DescribeInventoryDeletionsRequest)((Object)DescribeInventoryDeletionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

