/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.AssociationExecution;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse;

public class DescribeAssociationExecutionsPublisher
implements SdkPublisher<DescribeAssociationExecutionsResponse> {
    private final SsmAsyncClient client;
    private final DescribeAssociationExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAssociationExecutionsPublisher(SsmAsyncClient client, DescribeAssociationExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAssociationExecutionsPublisher(SsmAsyncClient client, DescribeAssociationExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAssociationExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAssociationExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssociationExecution> associationExecutions() {
        return this.flatMapIterable(response -> response.associationExecutions());
    }

    private class DescribeAssociationExecutionsResponseFetcher
    implements AsyncPageFetcher<DescribeAssociationExecutionsResponse> {
        private DescribeAssociationExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAssociationExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAssociationExecutionsResponse> nextPage(DescribeAssociationExecutionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAssociationExecutionsPublisher.this.client.describeAssociationExecutions(DescribeAssociationExecutionsPublisher.this.firstRequest);
            }
            return DescribeAssociationExecutionsPublisher.this.client.describeAssociationExecutions((DescribeAssociationExecutionsRequest)((Object)DescribeAssociationExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

