/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem;

public class ListResourceComplianceSummariesPublisher
implements SdkPublisher<ListResourceComplianceSummariesResponse> {
    private final SsmAsyncClient client;
    private final ListResourceComplianceSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceComplianceSummariesPublisher(SsmAsyncClient client, ListResourceComplianceSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceComplianceSummariesPublisher(SsmAsyncClient client, ListResourceComplianceSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceComplianceSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceComplianceSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceComplianceSummaryItem> resourceComplianceSummaryItems() {
        return this.flatMapIterable(response -> response.resourceComplianceSummaryItems());
    }

    private class ListResourceComplianceSummariesResponseFetcher
    implements AsyncPageFetcher<ListResourceComplianceSummariesResponse> {
        private ListResourceComplianceSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceComplianceSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceComplianceSummariesResponse> nextPage(ListResourceComplianceSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceComplianceSummariesPublisher.this.client.listResourceComplianceSummaries(ListResourceComplianceSummariesPublisher.this.firstRequest);
            }
            return ListResourceComplianceSummariesPublisher.this.client.listResourceComplianceSummaries((ListResourceComplianceSummariesRequest)((Object)ListResourceComplianceSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

