/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3OutputUrl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3OutputUrl> {
    private static final SdkField<String> OUTPUT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputUrl").getter(S3OutputUrl.getter(S3OutputUrl::outputUrl)).setter(S3OutputUrl.setter(Builder::outputUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3OutputUrl.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outputUrl;

    private S3OutputUrl(BuilderImpl builder) {
        this.outputUrl = builder.outputUrl;
    }

    public final String outputUrl() {
        return this.outputUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputUrl)) {
            return false;
        }
        S3OutputUrl other = (S3OutputUrl)obj;
        return Objects.equals(this.outputUrl(), other.outputUrl());
    }

    public final String toString() {
        return ToString.builder((String)"S3OutputUrl").add("OutputUrl", (Object)this.outputUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputUrl": {
                return Optional.ofNullable(clazz.cast(this.outputUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("OutputUrl", OUTPUT_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3OutputUrl, T> g) {
        return obj -> g.apply((S3OutputUrl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputUrl model) {
            this.outputUrl(model.outputUrl);
        }

        public final String getOutputUrl() {
            return this.outputUrl;
        }

        public final void setOutputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
        }

        @Override
        public final Builder outputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public S3OutputUrl build() {
            return new S3OutputUrl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3OutputUrl> {
        public Builder outputUrl(String var1);
    }
}

