/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstancePropertyFilterOperator {
    EQUAL("Equal"),
    NOT_EQUAL("NotEqual"),
    BEGIN_WITH("BeginWith"),
    LESS_THAN("LessThan"),
    GREATER_THAN("GreaterThan"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstancePropertyFilterOperator> VALUE_MAP;
    private final String value;

    private InstancePropertyFilterOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstancePropertyFilterOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstancePropertyFilterOperator> knownValues() {
        EnumSet<InstancePropertyFilterOperator> knownValues = EnumSet.allOf(InstancePropertyFilterOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstancePropertyFilterOperator.class, InstancePropertyFilterOperator::toString);
    }
}

