/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequestEntry;
import software.amazon.awssdk.services.ssm.model.Fault;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedCreateAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailedCreateAssociation> {
    private static final SdkField<CreateAssociationBatchRequestEntry> ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Entry").getter(FailedCreateAssociation.getter(FailedCreateAssociation::entry)).setter(FailedCreateAssociation.setter(Builder::entry)).constructor(CreateAssociationBatchRequestEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entry").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(FailedCreateAssociation.getter(FailedCreateAssociation::message)).setter(FailedCreateAssociation.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> FAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Fault").getter(FailedCreateAssociation.getter(FailedCreateAssociation::faultAsString)).setter(FailedCreateAssociation.setter(Builder::fault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fault").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_FIELD, MESSAGE_FIELD, FAULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FailedCreateAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CreateAssociationBatchRequestEntry entry;
    private final String message;
    private final String fault;

    private FailedCreateAssociation(BuilderImpl builder) {
        this.entry = builder.entry;
        this.message = builder.message;
        this.fault = builder.fault;
    }

    public final CreateAssociationBatchRequestEntry entry() {
        return this.entry;
    }

    public final String message() {
        return this.message;
    }

    public final Fault fault() {
        return Fault.fromValue(this.fault);
    }

    public final String faultAsString() {
        return this.fault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entry());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.faultAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCreateAssociation)) {
            return false;
        }
        FailedCreateAssociation other = (FailedCreateAssociation)obj;
        return Objects.equals(this.entry(), other.entry()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.faultAsString(), other.faultAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FailedCreateAssociation").add("Entry", (Object)this.entry()).add("Message", (Object)this.message()).add("Fault", (Object)this.faultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entry": {
                return Optional.ofNullable(clazz.cast(this.entry()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Fault": {
                return Optional.ofNullable(clazz.cast(this.faultAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Entry", ENTRY_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("Fault", FAULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedCreateAssociation, T> g) {
        return obj -> g.apply((FailedCreateAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CreateAssociationBatchRequestEntry entry;
        private String message;
        private String fault;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCreateAssociation model) {
            this.entry(model.entry);
            this.message(model.message);
            this.fault(model.fault);
        }

        public final CreateAssociationBatchRequestEntry.Builder getEntry() {
            return this.entry != null ? this.entry.toBuilder() : null;
        }

        public final void setEntry(CreateAssociationBatchRequestEntry.BuilderImpl entry) {
            this.entry = entry != null ? entry.build() : null;
        }

        @Override
        public final Builder entry(CreateAssociationBatchRequestEntry entry) {
            this.entry = entry;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getFault() {
            return this.fault;
        }

        public final void setFault(String fault) {
            this.fault = fault;
        }

        @Override
        public final Builder fault(String fault) {
            this.fault = fault;
            return this;
        }

        @Override
        public final Builder fault(Fault fault) {
            this.fault(fault == null ? null : fault.toString());
            return this;
        }

        public FailedCreateAssociation build() {
            return new FailedCreateAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailedCreateAssociation> {
        public Builder entry(CreateAssociationBatchRequestEntry var1);

        default public Builder entry(Consumer<CreateAssociationBatchRequestEntry.Builder> entry) {
            return this.entry((CreateAssociationBatchRequestEntry)((CreateAssociationBatchRequestEntry.Builder)CreateAssociationBatchRequestEntry.builder().applyMutation(entry)).build());
        }

        public Builder message(String var1);

        public Builder fault(String var1);

        public Builder fault(Fault var1);
    }
}

