/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse;

public class ListComplianceSummariesIterable
implements SdkIterable<ListComplianceSummariesResponse> {
    private final SsmClient client;
    private final ListComplianceSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComplianceSummariesIterable(SsmClient client, ListComplianceSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComplianceSummariesResponseFetcher();
    }

    public Iterator<ListComplianceSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComplianceSummaryItem> complianceSummaryItems() {
        Function<ListComplianceSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.complianceSummaryItems() != null) {
                return response.complianceSummaryItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComplianceSummariesResponseFetcher
    implements SyncPageFetcher<ListComplianceSummariesResponse> {
        private ListComplianceSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListComplianceSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComplianceSummariesResponse nextPage(ListComplianceSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListComplianceSummariesIterable.this.client.listComplianceSummaries(ListComplianceSummariesIterable.this.firstRequest);
            }
            return ListComplianceSummariesIterable.this.client.listComplianceSummaries((ListComplianceSummariesRequest)((Object)ListComplianceSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

