/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.model.PatchAction;
import software.amazon.awssdk.services.ssm.model.PatchComplianceLevel;
import software.amazon.awssdk.services.ssm.model.PatchComplianceStatus;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.services.ssm.model.PatchIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchRuleGroup;
import software.amazon.awssdk.services.ssm.model.PatchSource;
import software.amazon.awssdk.services.ssm.model.PatchSourceListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePatchBaselineResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, UpdatePatchBaselineResponse> {
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaselineId").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::baselineId)).setter(UpdatePatchBaselineResponse.setter(Builder::baselineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::name)).setter(UpdatePatchBaselineResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::operatingSystemAsString)).setter(UpdatePatchBaselineResponse.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<PatchFilterGroup> GLOBAL_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GlobalFilters").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::globalFilters)).setter(UpdatePatchBaselineResponse.setter(Builder::globalFilters)).constructor(PatchFilterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalFilters").build()}).build();
    private static final SdkField<PatchRuleGroup> APPROVAL_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApprovalRules").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::approvalRules)).setter(UpdatePatchBaselineResponse.setter(Builder::approvalRules)).constructor(PatchRuleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalRules").build()}).build();
    private static final SdkField<List<String>> APPROVED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApprovedPatches").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::approvedPatches)).setter(UpdatePatchBaselineResponse.setter(Builder::approvedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovedPatchesComplianceLevel").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::approvedPatchesComplianceLevelAsString)).setter(UpdatePatchBaselineResponse.setter(Builder::approvedPatchesComplianceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesComplianceLevel").build()}).build();
    private static final SdkField<Boolean> APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApprovedPatchesEnableNonSecurity").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::approvedPatchesEnableNonSecurity)).setter(UpdatePatchBaselineResponse.setter(Builder::approvedPatchesEnableNonSecurity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesEnableNonSecurity").build()}).build();
    private static final SdkField<List<String>> REJECTED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RejectedPatches").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::rejectedPatches)).setter(UpdatePatchBaselineResponse.setter(Builder::rejectedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REJECTED_PATCHES_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RejectedPatchesAction").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::rejectedPatchesActionAsString)).setter(UpdatePatchBaselineResponse.setter(Builder::rejectedPatchesAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatchesAction").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::createdDate)).setter(UpdatePatchBaselineResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<Instant> MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedDate").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::modifiedDate)).setter(UpdatePatchBaselineResponse.setter(Builder::modifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::description)).setter(UpdatePatchBaselineResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<PatchSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::sources)).setter(UpdatePatchBaselineResponse.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABLE_SECURITY_UPDATES_COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailableSecurityUpdatesComplianceStatus").getter(UpdatePatchBaselineResponse.getter(UpdatePatchBaselineResponse::availableSecurityUpdatesComplianceStatusAsString)).setter(UpdatePatchBaselineResponse.setter(Builder::availableSecurityUpdatesComplianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableSecurityUpdatesComplianceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_ID_FIELD, NAME_FIELD, OPERATING_SYSTEM_FIELD, GLOBAL_FILTERS_FIELD, APPROVAL_RULES_FIELD, APPROVED_PATCHES_FIELD, APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD, APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD, REJECTED_PATCHES_FIELD, REJECTED_PATCHES_ACTION_FIELD, CREATED_DATE_FIELD, MODIFIED_DATE_FIELD, DESCRIPTION_FIELD, SOURCES_FIELD, AVAILABLE_SECURITY_UPDATES_COMPLIANCE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePatchBaselineResponse.memberNameToFieldInitializer();
    private final String baselineId;
    private final String name;
    private final String operatingSystem;
    private final PatchFilterGroup globalFilters;
    private final PatchRuleGroup approvalRules;
    private final List<String> approvedPatches;
    private final String approvedPatchesComplianceLevel;
    private final Boolean approvedPatchesEnableNonSecurity;
    private final List<String> rejectedPatches;
    private final String rejectedPatchesAction;
    private final Instant createdDate;
    private final Instant modifiedDate;
    private final String description;
    private final List<PatchSource> sources;
    private final String availableSecurityUpdatesComplianceStatus;

    private UpdatePatchBaselineResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.name = builder.name;
        this.operatingSystem = builder.operatingSystem;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.approvedPatchesComplianceLevel = builder.approvedPatchesComplianceLevel;
        this.approvedPatchesEnableNonSecurity = builder.approvedPatchesEnableNonSecurity;
        this.rejectedPatches = builder.rejectedPatches;
        this.rejectedPatchesAction = builder.rejectedPatchesAction;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
        this.description = builder.description;
        this.sources = builder.sources;
        this.availableSecurityUpdatesComplianceStatus = builder.availableSecurityUpdatesComplianceStatus;
    }

    public final String baselineId() {
        return this.baselineId;
    }

    public final String name() {
        return this.name;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final PatchFilterGroup globalFilters() {
        return this.globalFilters;
    }

    public final PatchRuleGroup approvalRules() {
        return this.approvalRules;
    }

    public final boolean hasApprovedPatches() {
        return this.approvedPatches != null && !(this.approvedPatches instanceof SdkAutoConstructList);
    }

    public final List<String> approvedPatches() {
        return this.approvedPatches;
    }

    public final PatchComplianceLevel approvedPatchesComplianceLevel() {
        return PatchComplianceLevel.fromValue(this.approvedPatchesComplianceLevel);
    }

    public final String approvedPatchesComplianceLevelAsString() {
        return this.approvedPatchesComplianceLevel;
    }

    public final Boolean approvedPatchesEnableNonSecurity() {
        return this.approvedPatchesEnableNonSecurity;
    }

    public final boolean hasRejectedPatches() {
        return this.rejectedPatches != null && !(this.rejectedPatches instanceof SdkAutoConstructList);
    }

    public final List<String> rejectedPatches() {
        return this.rejectedPatches;
    }

    public final PatchAction rejectedPatchesAction() {
        return PatchAction.fromValue(this.rejectedPatchesAction);
    }

    public final String rejectedPatchesActionAsString() {
        return this.rejectedPatchesAction;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant modifiedDate() {
        return this.modifiedDate;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<PatchSource> sources() {
        return this.sources;
    }

    public final PatchComplianceStatus availableSecurityUpdatesComplianceStatus() {
        return PatchComplianceStatus.fromValue(this.availableSecurityUpdatesComplianceStatus);
    }

    public final String availableSecurityUpdatesComplianceStatusAsString() {
        return this.availableSecurityUpdatesComplianceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovedPatches() ? this.approvedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatchesComplianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatchesEnableNonSecurity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRejectedPatches() ? this.rejectedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectedPatchesActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availableSecurityUpdatesComplianceStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePatchBaselineResponse)) {
            return false;
        }
        UpdatePatchBaselineResponse other = (UpdatePatchBaselineResponse)((Object)obj);
        return Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.globalFilters(), other.globalFilters()) && Objects.equals(this.approvalRules(), other.approvalRules()) && this.hasApprovedPatches() == other.hasApprovedPatches() && Objects.equals(this.approvedPatches(), other.approvedPatches()) && Objects.equals(this.approvedPatchesComplianceLevelAsString(), other.approvedPatchesComplianceLevelAsString()) && Objects.equals(this.approvedPatchesEnableNonSecurity(), other.approvedPatchesEnableNonSecurity()) && this.hasRejectedPatches() == other.hasRejectedPatches() && Objects.equals(this.rejectedPatches(), other.rejectedPatches()) && Objects.equals(this.rejectedPatchesActionAsString(), other.rejectedPatchesActionAsString()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.modifiedDate(), other.modifiedDate()) && Objects.equals(this.description(), other.description()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.availableSecurityUpdatesComplianceStatusAsString(), other.availableSecurityUpdatesComplianceStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePatchBaselineResponse").add("BaselineId", (Object)this.baselineId()).add("Name", (Object)this.name()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("GlobalFilters", (Object)this.globalFilters()).add("ApprovalRules", (Object)this.approvalRules()).add("ApprovedPatches", this.hasApprovedPatches() ? this.approvedPatches() : null).add("ApprovedPatchesComplianceLevel", (Object)this.approvedPatchesComplianceLevelAsString()).add("ApprovedPatchesEnableNonSecurity", (Object)this.approvedPatchesEnableNonSecurity()).add("RejectedPatches", this.hasRejectedPatches() ? this.rejectedPatches() : null).add("RejectedPatchesAction", (Object)this.rejectedPatchesActionAsString()).add("CreatedDate", (Object)this.createdDate()).add("ModifiedDate", (Object)this.modifiedDate()).add("Description", (Object)this.description()).add("Sources", this.hasSources() ? this.sources() : null).add("AvailableSecurityUpdatesComplianceStatus", (Object)this.availableSecurityUpdatesComplianceStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.ofNullable(clazz.cast(this.baselineId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "GlobalFilters": {
                return Optional.ofNullable(clazz.cast(this.globalFilters()));
            }
            case "ApprovalRules": {
                return Optional.ofNullable(clazz.cast(this.approvalRules()));
            }
            case "ApprovedPatches": {
                return Optional.ofNullable(clazz.cast(this.approvedPatches()));
            }
            case "ApprovedPatchesComplianceLevel": {
                return Optional.ofNullable(clazz.cast(this.approvedPatchesComplianceLevelAsString()));
            }
            case "ApprovedPatchesEnableNonSecurity": {
                return Optional.ofNullable(clazz.cast(this.approvedPatchesEnableNonSecurity()));
            }
            case "RejectedPatches": {
                return Optional.ofNullable(clazz.cast(this.rejectedPatches()));
            }
            case "RejectedPatchesAction": {
                return Optional.ofNullable(clazz.cast(this.rejectedPatchesActionAsString()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "ModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.modifiedDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "AvailableSecurityUpdatesComplianceStatus": {
                return Optional.ofNullable(clazz.cast(this.availableSecurityUpdatesComplianceStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BaselineId", BASELINE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
        map.put("GlobalFilters", GLOBAL_FILTERS_FIELD);
        map.put("ApprovalRules", APPROVAL_RULES_FIELD);
        map.put("ApprovedPatches", APPROVED_PATCHES_FIELD);
        map.put("ApprovedPatchesComplianceLevel", APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD);
        map.put("ApprovedPatchesEnableNonSecurity", APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD);
        map.put("RejectedPatches", REJECTED_PATCHES_FIELD);
        map.put("RejectedPatchesAction", REJECTED_PATCHES_ACTION_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("ModifiedDate", MODIFIED_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Sources", SOURCES_FIELD);
        map.put("AvailableSecurityUpdatesComplianceStatus", AVAILABLE_SECURITY_UPDATES_COMPLIANCE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePatchBaselineResponse, T> g) {
        return obj -> g.apply((UpdatePatchBaselineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String baselineId;
        private String name;
        private String operatingSystem;
        private PatchFilterGroup globalFilters;
        private PatchRuleGroup approvalRules;
        private List<String> approvedPatches = DefaultSdkAutoConstructList.getInstance();
        private String approvedPatchesComplianceLevel;
        private Boolean approvedPatchesEnableNonSecurity;
        private List<String> rejectedPatches = DefaultSdkAutoConstructList.getInstance();
        private String rejectedPatchesAction;
        private Instant createdDate;
        private Instant modifiedDate;
        private String description;
        private List<PatchSource> sources = DefaultSdkAutoConstructList.getInstance();
        private String availableSecurityUpdatesComplianceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePatchBaselineResponse model) {
            super(model);
            this.baselineId(model.baselineId);
            this.name(model.name);
            this.operatingSystem(model.operatingSystem);
            this.globalFilters(model.globalFilters);
            this.approvalRules(model.approvalRules);
            this.approvedPatches(model.approvedPatches);
            this.approvedPatchesComplianceLevel(model.approvedPatchesComplianceLevel);
            this.approvedPatchesEnableNonSecurity(model.approvedPatchesEnableNonSecurity);
            this.rejectedPatches(model.rejectedPatches);
            this.rejectedPatchesAction(model.rejectedPatchesAction);
            this.createdDate(model.createdDate);
            this.modifiedDate(model.modifiedDate);
            this.description(model.description);
            this.sources(model.sources);
            this.availableSecurityUpdatesComplianceStatus(model.availableSecurityUpdatesComplianceStatus);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return this.globalFilters != null ? this.globalFilters.toBuilder() : null;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return this.approvalRules != null ? this.approvalRules.toBuilder() : null;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final Collection<String> getApprovedPatches() {
            if (this.approvedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.approvedPatches;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String ... approvedPatches) {
            this.approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final String getApprovedPatchesComplianceLevel() {
            return this.approvedPatchesComplianceLevel;
        }

        public final void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel == null ? null : approvedPatchesComplianceLevel.toString());
            return this;
        }

        public final Boolean getApprovedPatchesEnableNonSecurity() {
            return this.approvedPatchesEnableNonSecurity;
        }

        public final void setApprovedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
        }

        @Override
        public final Builder approvedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
            return this;
        }

        public final Collection<String> getRejectedPatches() {
            if (this.rejectedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rejectedPatches;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String ... rejectedPatches) {
            this.rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final String getRejectedPatchesAction() {
            return this.rejectedPatchesAction;
        }

        public final void setRejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
        }

        @Override
        public final Builder rejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
            return this;
        }

        @Override
        public final Builder rejectedPatchesAction(PatchAction rejectedPatchesAction) {
            this.rejectedPatchesAction(rejectedPatchesAction == null ? null : rejectedPatchesAction.toString());
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getModifiedDate() {
            return this.modifiedDate;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<PatchSource.Builder> getSources() {
            List<PatchSource.Builder> result = PatchSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<PatchSource.BuilderImpl> sources) {
            this.sources = PatchSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<PatchSource> sources) {
            this.sources = PatchSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(PatchSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<PatchSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (PatchSource)((PatchSource.Builder)PatchSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailableSecurityUpdatesComplianceStatus() {
            return this.availableSecurityUpdatesComplianceStatus;
        }

        public final void setAvailableSecurityUpdatesComplianceStatus(String availableSecurityUpdatesComplianceStatus) {
            this.availableSecurityUpdatesComplianceStatus = availableSecurityUpdatesComplianceStatus;
        }

        @Override
        public final Builder availableSecurityUpdatesComplianceStatus(String availableSecurityUpdatesComplianceStatus) {
            this.availableSecurityUpdatesComplianceStatus = availableSecurityUpdatesComplianceStatus;
            return this;
        }

        @Override
        public final Builder availableSecurityUpdatesComplianceStatus(PatchComplianceStatus availableSecurityUpdatesComplianceStatus) {
            this.availableSecurityUpdatesComplianceStatus(availableSecurityUpdatesComplianceStatus == null ? null : availableSecurityUpdatesComplianceStatus.toString());
            return this;
        }

        @Override
        public UpdatePatchBaselineResponse build() {
            return new UpdatePatchBaselineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePatchBaselineResponse> {
        public Builder baselineId(String var1);

        public Builder name(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder globalFilters(PatchFilterGroup var1);

        default public Builder globalFilters(Consumer<PatchFilterGroup.Builder> globalFilters) {
            return this.globalFilters((PatchFilterGroup)((PatchFilterGroup.Builder)PatchFilterGroup.builder().applyMutation(globalFilters)).build());
        }

        public Builder approvalRules(PatchRuleGroup var1);

        default public Builder approvalRules(Consumer<PatchRuleGroup.Builder> approvalRules) {
            return this.approvalRules((PatchRuleGroup)((PatchRuleGroup.Builder)PatchRuleGroup.builder().applyMutation(approvalRules)).build());
        }

        public Builder approvedPatches(Collection<String> var1);

        public Builder approvedPatches(String ... var1);

        public Builder approvedPatchesComplianceLevel(String var1);

        public Builder approvedPatchesComplianceLevel(PatchComplianceLevel var1);

        public Builder approvedPatchesEnableNonSecurity(Boolean var1);

        public Builder rejectedPatches(Collection<String> var1);

        public Builder rejectedPatches(String ... var1);

        public Builder rejectedPatchesAction(String var1);

        public Builder rejectedPatchesAction(PatchAction var1);

        public Builder createdDate(Instant var1);

        public Builder modifiedDate(Instant var1);

        public Builder description(String var1);

        public Builder sources(Collection<PatchSource> var1);

        public Builder sources(PatchSource ... var1);

        public Builder sources(Consumer<PatchSource.Builder> ... var1);

        public Builder availableSecurityUpdatesComplianceStatus(String var1);

        public Builder availableSecurityUpdatesComplianceStatus(PatchComplianceStatus var1);
    }
}

