/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StepExecutionFilterKey {
    START_TIME_BEFORE("StartTimeBefore"),
    START_TIME_AFTER("StartTimeAfter"),
    STEP_EXECUTION_STATUS("StepExecutionStatus"),
    STEP_EXECUTION_ID("StepExecutionId"),
    STEP_NAME("StepName"),
    ACTION("Action"),
    PARENT_STEP_EXECUTION_ID("ParentStepExecutionId"),
    PARENT_STEP_ITERATION("ParentStepIteration"),
    PARENT_STEP_ITERATOR_VALUE("ParentStepIteratorValue"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StepExecutionFilterKey> VALUE_MAP;
    private final String value;

    private StepExecutionFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StepExecutionFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StepExecutionFilterKey> knownValues() {
        EnumSet<StepExecutionFilterKey> knownValues = EnumSet.allOf(StepExecutionFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StepExecutionFilterKey.class, StepExecutionFilterKey::toString);
    }
}

