/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeFilterKey {
    AGENT_TYPE("AgentType"),
    AGENT_VERSION("AgentVersion"),
    COMPUTER_NAME("ComputerName"),
    INSTANCE_ID("InstanceId"),
    INSTANCE_STATUS("InstanceStatus"),
    IP_ADDRESS("IpAddress"),
    MANAGED_STATUS("ManagedStatus"),
    PLATFORM_NAME("PlatformName"),
    PLATFORM_TYPE("PlatformType"),
    PLATFORM_VERSION("PlatformVersion"),
    RESOURCE_TYPE("ResourceType"),
    ORGANIZATIONAL_UNIT_ID("OrganizationalUnitId"),
    ORGANIZATIONAL_UNIT_PATH("OrganizationalUnitPath"),
    REGION("Region"),
    ACCOUNT_ID("AccountId"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeFilterKey> VALUE_MAP;
    private final String value;

    private NodeFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeFilterKey> knownValues() {
        EnumSet<NodeFilterKey> knownValues = EnumSet.allOf(NodeFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeFilterKey.class, NodeFilterKey::toString);
    }
}

