/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstancePropertyFilterKey {
    INSTANCE_IDS("InstanceIds"),
    AGENT_VERSION("AgentVersion"),
    PING_STATUS("PingStatus"),
    PLATFORM_TYPES("PlatformTypes"),
    DOCUMENT_NAME("DocumentName"),
    ACTIVATION_IDS("ActivationIds"),
    IAM_ROLE("IamRole"),
    RESOURCE_TYPE("ResourceType"),
    ASSOCIATION_STATUS("AssociationStatus"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstancePropertyFilterKey> VALUE_MAP;
    private final String value;

    private InstancePropertyFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstancePropertyFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstancePropertyFilterKey> knownValues() {
        EnumSet<InstancePropertyFilterKey> knownValues = EnumSet.allOf(InstancePropertyFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstancePropertyFilterKey.class, InstancePropertyFilterKey::toString);
    }
}

