/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PatchComplianceLevel {
    CRITICAL("CRITICAL"),
    HIGH("HIGH"),
    MEDIUM("MEDIUM"),
    LOW("LOW"),
    INFORMATIONAL("INFORMATIONAL"),
    UNSPECIFIED("UNSPECIFIED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PatchComplianceLevel> VALUE_MAP;
    private final String value;

    private PatchComplianceLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PatchComplianceLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PatchComplianceLevel> knownValues() {
        EnumSet<PatchComplianceLevel> knownValues = EnumSet.allOf(PatchComplianceLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PatchComplianceLevel.class, PatchComplianceLevel::toString);
    }
}

