/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeFilterOperatorType {
    EQUAL("Equal"),
    NOT_EQUAL("NotEqual"),
    BEGIN_WITH("BeginWith"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeFilterOperatorType> VALUE_MAP;
    private final String value;

    private NodeFilterOperatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeFilterOperatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeFilterOperatorType> knownValues() {
        EnumSet<NodeFilterOperatorType> knownValues = EnumSet.allOf(NodeFilterOperatorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeFilterOperatorType.class, NodeFilterOperatorType::toString);
    }
}

