/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AttachmentsSource;
import software.amazon.awssdk.services.ssm.model.AttachmentsSourceListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentFormat;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDocumentRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, UpdateDocumentRequest> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(UpdateDocumentRequest.getter(UpdateDocumentRequest::content)).setter(UpdateDocumentRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<List<AttachmentsSource>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attachments").getter(UpdateDocumentRequest.getter(UpdateDocumentRequest::attachments)).setter(UpdateDocumentRequest.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentsSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateDocumentRequest.getter(UpdateDocumentRequest::name)).setter(UpdateDocumentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateDocumentRequest.getter(UpdateDocumentRequest::displayName)).setter(UpdateDocumentRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionName").getter(UpdateDocumentRequest.getter(UpdateDocumentRequest::versionName)).setter(UpdateDocumentRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(UpdateDocumentRequest.getter(UpdateDocumentRequest::documentVersion)).setter(UpdateDocumentRequest.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentFormat").getter(UpdateDocumentRequest.getter(UpdateDocumentRequest::documentFormatAsString)).setter(UpdateDocumentRequest.setter(Builder::documentFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(UpdateDocumentRequest.getter(UpdateDocumentRequest::targetType)).setter(UpdateDocumentRequest.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, ATTACHMENTS_FIELD, NAME_FIELD, DISPLAY_NAME_FIELD, VERSION_NAME_FIELD, DOCUMENT_VERSION_FIELD, DOCUMENT_FORMAT_FIELD, TARGET_TYPE_FIELD));
    private final String content;
    private final List<AttachmentsSource> attachments;
    private final String name;
    private final String displayName;
    private final String versionName;
    private final String documentVersion;
    private final String documentFormat;
    private final String targetType;

    private UpdateDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.attachments = builder.attachments;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.versionName = builder.versionName;
        this.documentVersion = builder.documentVersion;
        this.documentFormat = builder.documentFormat;
        this.targetType = builder.targetType;
    }

    public final String content() {
        return this.content;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<AttachmentsSource> attachments() {
        return this.attachments;
    }

    public final String name() {
        return this.name;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(this.documentFormat);
    }

    public final String documentFormatAsString() {
        return this.documentFormat;
    }

    public final String targetType() {
        return this.targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentRequest)) {
            return false;
        }
        UpdateDocumentRequest other = (UpdateDocumentRequest)((Object)obj);
        return Objects.equals(this.content(), other.content()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.documentFormatAsString(), other.documentFormatAsString()) && Objects.equals(this.targetType(), other.targetType());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDocumentRequest").add("Content", (Object)this.content()).add("Attachments", this.hasAttachments() ? this.attachments() : null).add("Name", (Object)this.name()).add("DisplayName", (Object)this.displayName()).add("VersionName", (Object)this.versionName()).add("DocumentVersion", (Object)this.documentVersion()).add("DocumentFormat", (Object)this.documentFormatAsString()).add("TargetType", (Object)this.targetType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "DocumentFormat": {
                return Optional.ofNullable(clazz.cast(this.documentFormatAsString()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDocumentRequest, T> g) {
        return obj -> g.apply((UpdateDocumentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String content;
        private List<AttachmentsSource> attachments = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String displayName;
        private String versionName;
        private String documentVersion;
        private String documentFormat;
        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentRequest model) {
            super(model);
            this.content(model.content);
            this.attachments(model.attachments);
            this.name(model.name);
            this.displayName(model.displayName);
            this.versionName(model.versionName);
            this.documentVersion(model.documentVersion);
            this.documentFormat(model.documentFormat);
            this.targetType(model.targetType);
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final List<AttachmentsSource.Builder> getAttachments() {
            List<AttachmentsSource.Builder> result = AttachmentsSourceListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentsSource.BuilderImpl> attachments) {
            this.attachments = AttachmentsSourceListCopier.copyFromBuilder(attachments);
        }

        @Override
        @Transient
        public final Builder attachments(Collection<AttachmentsSource> attachments) {
            this.attachments = AttachmentsSourceListCopier.copy(attachments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(AttachmentsSource ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentsSource.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (AttachmentsSource)((AttachmentsSource.Builder)AttachmentsSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        @Transient
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        @Transient
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getDocumentFormat() {
            return this.documentFormat;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        @Override
        @Transient
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        @Transient
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDocumentRequest build() {
            return new UpdateDocumentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDocumentRequest> {
        public Builder content(String var1);

        public Builder attachments(Collection<AttachmentsSource> var1);

        public Builder attachments(AttachmentsSource ... var1);

        public Builder attachments(Consumer<AttachmentsSource.Builder> ... var1);

        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder versionName(String var1);

        public Builder documentVersion(String var1);

        public Builder documentFormat(String var1);

        public Builder documentFormat(DocumentFormat var1);

        public Builder targetType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

