/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceTypeForTagging {
    DOCUMENT("Document"),
    MANAGED_INSTANCE("ManagedInstance"),
    MAINTENANCE_WINDOW("MaintenanceWindow"),
    PARAMETER("Parameter"),
    PATCH_BASELINE("PatchBaseline"),
    OPS_ITEM("OpsItem"),
    OPS_METADATA("OpsMetadata"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceTypeForTagging> VALUE_MAP;
    private final String value;

    private ResourceTypeForTagging(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceTypeForTagging fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceTypeForTagging> knownValues() {
        EnumSet<ResourceTypeForTagging> knownValues = EnumSet.allOf(ResourceTypeForTagging.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceTypeForTagging.class, ResourceTypeForTagging::toString);
    }
}

