/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchSource;

final class PatchSourceListCopier {
    PatchSourceListCopier() {
    }

    static List<PatchSource> copy(Collection<? extends PatchSource> patchSourceListParam) {
        Object list;
        if (patchSourceListParam == null || patchSourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            patchSourceListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PatchSource> copyFromBuilder(Collection<? extends PatchSource.Builder> patchSourceListParam) {
        Object list;
        if (patchSourceListParam == null || patchSourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            patchSourceListParam.forEach(entry -> {
                PatchSource member = (PatchSource)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PatchSource.Builder> copyToBuilder(Collection<? extends PatchSource> patchSourceListParam) {
        Object list;
        if (patchSourceListParam == null || patchSourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            patchSourceListParam.forEach(entry -> {
                PatchSource.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

