/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchAdvisoryIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchBugzillaIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchCVEIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Patch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Patch> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Patch.getter(Patch::id)).setter(Patch.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReleaseDate").getter(Patch.getter(Patch::releaseDate)).setter(Patch.setter(Builder::releaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Patch.getter(Patch::title)).setter(Patch.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Patch.getter(Patch::description)).setter(Patch.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONTENT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentUrl").getter(Patch.getter(Patch::contentUrl)).setter(Patch.setter(Builder::contentUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentUrl").build()}).build();
    private static final SdkField<String> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Vendor").getter(Patch.getter(Patch::vendor)).setter(Patch.setter(Builder::vendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()}).build();
    private static final SdkField<String> PRODUCT_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductFamily").getter(Patch.getter(Patch::productFamily)).setter(Patch.setter(Builder::productFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductFamily").build()}).build();
    private static final SdkField<String> PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Product").getter(Patch.getter(Patch::product)).setter(Patch.setter(Builder::product)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Classification").getter(Patch.getter(Patch::classification)).setter(Patch.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<String> MSRC_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MsrcSeverity").getter(Patch.getter(Patch::msrcSeverity)).setter(Patch.setter(Builder::msrcSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MsrcSeverity").build()}).build();
    private static final SdkField<String> KB_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KbNumber").getter(Patch.getter(Patch::kbNumber)).setter(Patch.setter(Builder::kbNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KbNumber").build()}).build();
    private static final SdkField<String> MSRC_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MsrcNumber").getter(Patch.getter(Patch::msrcNumber)).setter(Patch.setter(Builder::msrcNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MsrcNumber").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(Patch.getter(Patch::language)).setter(Patch.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<List<String>> ADVISORY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvisoryIds").getter(Patch.getter(Patch::advisoryIds)).setter(Patch.setter(Builder::advisoryIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvisoryIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BUGZILLA_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BugzillaIds").getter(Patch.getter(Patch::bugzillaIds)).setter(Patch.setter(Builder::bugzillaIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BugzillaIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CVE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CVEIds").getter(Patch.getter(Patch::cveIds)).setter(Patch.setter(Builder::cveIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CVEIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Patch.getter(Patch::name)).setter(Patch.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Epoch").getter(Patch.getter(Patch::epoch)).setter(Patch.setter(Builder::epoch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Epoch").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(Patch.getter(Patch::version)).setter(Patch.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> RELEASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Release").getter(Patch.getter(Patch::release)).setter(Patch.setter(Builder::release)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Release").build()}).build();
    private static final SdkField<String> ARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arch").getter(Patch.getter(Patch::arch)).setter(Patch.setter(Builder::arch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arch").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(Patch.getter(Patch::severity)).setter(Patch.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Repository").getter(Patch.getter(Patch::repository)).setter(Patch.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Repository").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RELEASE_DATE_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, CONTENT_URL_FIELD, VENDOR_FIELD, PRODUCT_FAMILY_FIELD, PRODUCT_FIELD, CLASSIFICATION_FIELD, MSRC_SEVERITY_FIELD, KB_NUMBER_FIELD, MSRC_NUMBER_FIELD, LANGUAGE_FIELD, ADVISORY_IDS_FIELD, BUGZILLA_IDS_FIELD, CVE_IDS_FIELD, NAME_FIELD, EPOCH_FIELD, VERSION_FIELD, RELEASE_FIELD, ARCH_FIELD, SEVERITY_FIELD, REPOSITORY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Instant releaseDate;
    private final String title;
    private final String description;
    private final String contentUrl;
    private final String vendor;
    private final String productFamily;
    private final String product;
    private final String classification;
    private final String msrcSeverity;
    private final String kbNumber;
    private final String msrcNumber;
    private final String language;
    private final List<String> advisoryIds;
    private final List<String> bugzillaIds;
    private final List<String> cveIds;
    private final String name;
    private final Integer epoch;
    private final String version;
    private final String release;
    private final String arch;
    private final String severity;
    private final String repository;

    private Patch(BuilderImpl builder) {
        this.id = builder.id;
        this.releaseDate = builder.releaseDate;
        this.title = builder.title;
        this.description = builder.description;
        this.contentUrl = builder.contentUrl;
        this.vendor = builder.vendor;
        this.productFamily = builder.productFamily;
        this.product = builder.product;
        this.classification = builder.classification;
        this.msrcSeverity = builder.msrcSeverity;
        this.kbNumber = builder.kbNumber;
        this.msrcNumber = builder.msrcNumber;
        this.language = builder.language;
        this.advisoryIds = builder.advisoryIds;
        this.bugzillaIds = builder.bugzillaIds;
        this.cveIds = builder.cveIds;
        this.name = builder.name;
        this.epoch = builder.epoch;
        this.version = builder.version;
        this.release = builder.release;
        this.arch = builder.arch;
        this.severity = builder.severity;
        this.repository = builder.repository;
    }

    public final String id() {
        return this.id;
    }

    public final Instant releaseDate() {
        return this.releaseDate;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String contentUrl() {
        return this.contentUrl;
    }

    public final String vendor() {
        return this.vendor;
    }

    public final String productFamily() {
        return this.productFamily;
    }

    public final String product() {
        return this.product;
    }

    public final String classification() {
        return this.classification;
    }

    public final String msrcSeverity() {
        return this.msrcSeverity;
    }

    public final String kbNumber() {
        return this.kbNumber;
    }

    public final String msrcNumber() {
        return this.msrcNumber;
    }

    public final String language() {
        return this.language;
    }

    public final boolean hasAdvisoryIds() {
        return this.advisoryIds != null && !(this.advisoryIds instanceof SdkAutoConstructList);
    }

    public final List<String> advisoryIds() {
        return this.advisoryIds;
    }

    public final boolean hasBugzillaIds() {
        return this.bugzillaIds != null && !(this.bugzillaIds instanceof SdkAutoConstructList);
    }

    public final List<String> bugzillaIds() {
        return this.bugzillaIds;
    }

    public final boolean hasCveIds() {
        return this.cveIds != null && !(this.cveIds instanceof SdkAutoConstructList);
    }

    public final List<String> cveIds() {
        return this.cveIds;
    }

    public final String name() {
        return this.name;
    }

    public final Integer epoch() {
        return this.epoch;
    }

    public final String version() {
        return this.version;
    }

    public final String release() {
        return this.release;
    }

    public final String arch() {
        return this.arch;
    }

    public final String severity() {
        return this.severity;
    }

    public final String repository() {
        return this.repository;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.productFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.product());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.msrcSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(this.kbNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.msrcNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvisoryIds() ? this.advisoryIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBugzillaIds() ? this.bugzillaIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCveIds() ? this.cveIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.epoch());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.release());
        hashCode = 31 * hashCode + Objects.hashCode(this.arch());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Patch)) {
            return false;
        }
        Patch other = (Patch)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.releaseDate(), other.releaseDate()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.contentUrl(), other.contentUrl()) && Objects.equals(this.vendor(), other.vendor()) && Objects.equals(this.productFamily(), other.productFamily()) && Objects.equals(this.product(), other.product()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.msrcSeverity(), other.msrcSeverity()) && Objects.equals(this.kbNumber(), other.kbNumber()) && Objects.equals(this.msrcNumber(), other.msrcNumber()) && Objects.equals(this.language(), other.language()) && this.hasAdvisoryIds() == other.hasAdvisoryIds() && Objects.equals(this.advisoryIds(), other.advisoryIds()) && this.hasBugzillaIds() == other.hasBugzillaIds() && Objects.equals(this.bugzillaIds(), other.bugzillaIds()) && this.hasCveIds() == other.hasCveIds() && Objects.equals(this.cveIds(), other.cveIds()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.epoch(), other.epoch()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.release(), other.release()) && Objects.equals(this.arch(), other.arch()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.repository(), other.repository());
    }

    public final String toString() {
        return ToString.builder((String)"Patch").add("Id", (Object)this.id()).add("ReleaseDate", (Object)this.releaseDate()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("ContentUrl", (Object)this.contentUrl()).add("Vendor", (Object)this.vendor()).add("ProductFamily", (Object)this.productFamily()).add("Product", (Object)this.product()).add("Classification", (Object)this.classification()).add("MsrcSeverity", (Object)this.msrcSeverity()).add("KbNumber", (Object)this.kbNumber()).add("MsrcNumber", (Object)this.msrcNumber()).add("Language", (Object)this.language()).add("AdvisoryIds", this.hasAdvisoryIds() ? this.advisoryIds() : null).add("BugzillaIds", this.hasBugzillaIds() ? this.bugzillaIds() : null).add("CVEIds", this.hasCveIds() ? this.cveIds() : null).add("Name", (Object)this.name()).add("Epoch", (Object)this.epoch()).add("Version", (Object)this.version()).add("Release", (Object)this.release()).add("Arch", (Object)this.arch()).add("Severity", (Object)this.severity()).add("Repository", (Object)this.repository()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.releaseDate()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ContentUrl": {
                return Optional.ofNullable(clazz.cast(this.contentUrl()));
            }
            case "Vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
            case "ProductFamily": {
                return Optional.ofNullable(clazz.cast(this.productFamily()));
            }
            case "Product": {
                return Optional.ofNullable(clazz.cast(this.product()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "MsrcSeverity": {
                return Optional.ofNullable(clazz.cast(this.msrcSeverity()));
            }
            case "KbNumber": {
                return Optional.ofNullable(clazz.cast(this.kbNumber()));
            }
            case "MsrcNumber": {
                return Optional.ofNullable(clazz.cast(this.msrcNumber()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "AdvisoryIds": {
                return Optional.ofNullable(clazz.cast(this.advisoryIds()));
            }
            case "BugzillaIds": {
                return Optional.ofNullable(clazz.cast(this.bugzillaIds()));
            }
            case "CVEIds": {
                return Optional.ofNullable(clazz.cast(this.cveIds()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Epoch": {
                return Optional.ofNullable(clazz.cast(this.epoch()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Release": {
                return Optional.ofNullable(clazz.cast(this.release()));
            }
            case "Arch": {
                return Optional.ofNullable(clazz.cast(this.arch()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "Repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Patch, T> g) {
        return obj -> g.apply((Patch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Instant releaseDate;
        private String title;
        private String description;
        private String contentUrl;
        private String vendor;
        private String productFamily;
        private String product;
        private String classification;
        private String msrcSeverity;
        private String kbNumber;
        private String msrcNumber;
        private String language;
        private List<String> advisoryIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> bugzillaIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> cveIds = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Integer epoch;
        private String version;
        private String release;
        private String arch;
        private String severity;
        private String repository;

        private BuilderImpl() {
        }

        private BuilderImpl(Patch model) {
            this.id(model.id);
            this.releaseDate(model.releaseDate);
            this.title(model.title);
            this.description(model.description);
            this.contentUrl(model.contentUrl);
            this.vendor(model.vendor);
            this.productFamily(model.productFamily);
            this.product(model.product);
            this.classification(model.classification);
            this.msrcSeverity(model.msrcSeverity);
            this.kbNumber(model.kbNumber);
            this.msrcNumber(model.msrcNumber);
            this.language(model.language);
            this.advisoryIds(model.advisoryIds);
            this.bugzillaIds(model.bugzillaIds);
            this.cveIds(model.cveIds);
            this.name(model.name);
            this.epoch(model.epoch);
            this.version(model.version);
            this.release(model.release);
            this.arch(model.arch);
            this.severity(model.severity);
            this.repository(model.repository);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getReleaseDate() {
            return this.releaseDate;
        }

        public final void setReleaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
        }

        @Override
        @Transient
        public final Builder releaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContentUrl() {
            return this.contentUrl;
        }

        public final void setContentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
        }

        @Override
        @Transient
        public final Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            return this;
        }

        public final String getVendor() {
            return this.vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        @Transient
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final String getProductFamily() {
            return this.productFamily;
        }

        public final void setProductFamily(String productFamily) {
            this.productFamily = productFamily;
        }

        @Override
        @Transient
        public final Builder productFamily(String productFamily) {
            this.productFamily = productFamily;
            return this;
        }

        public final String getProduct() {
            return this.product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        @Transient
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final String getClassification() {
            return this.classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        @Transient
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final String getMsrcSeverity() {
            return this.msrcSeverity;
        }

        public final void setMsrcSeverity(String msrcSeverity) {
            this.msrcSeverity = msrcSeverity;
        }

        @Override
        @Transient
        public final Builder msrcSeverity(String msrcSeverity) {
            this.msrcSeverity = msrcSeverity;
            return this;
        }

        public final String getKbNumber() {
            return this.kbNumber;
        }

        public final void setKbNumber(String kbNumber) {
            this.kbNumber = kbNumber;
        }

        @Override
        @Transient
        public final Builder kbNumber(String kbNumber) {
            this.kbNumber = kbNumber;
            return this;
        }

        public final String getMsrcNumber() {
            return this.msrcNumber;
        }

        public final void setMsrcNumber(String msrcNumber) {
            this.msrcNumber = msrcNumber;
        }

        @Override
        @Transient
        public final Builder msrcNumber(String msrcNumber) {
            this.msrcNumber = msrcNumber;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        @Transient
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Collection<String> getAdvisoryIds() {
            if (this.advisoryIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.advisoryIds;
        }

        public final void setAdvisoryIds(Collection<String> advisoryIds) {
            this.advisoryIds = PatchAdvisoryIdListCopier.copy(advisoryIds);
        }

        @Override
        @Transient
        public final Builder advisoryIds(Collection<String> advisoryIds) {
            this.advisoryIds = PatchAdvisoryIdListCopier.copy(advisoryIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder advisoryIds(String ... advisoryIds) {
            this.advisoryIds(Arrays.asList(advisoryIds));
            return this;
        }

        public final Collection<String> getBugzillaIds() {
            if (this.bugzillaIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bugzillaIds;
        }

        public final void setBugzillaIds(Collection<String> bugzillaIds) {
            this.bugzillaIds = PatchBugzillaIdListCopier.copy(bugzillaIds);
        }

        @Override
        @Transient
        public final Builder bugzillaIds(Collection<String> bugzillaIds) {
            this.bugzillaIds = PatchBugzillaIdListCopier.copy(bugzillaIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bugzillaIds(String ... bugzillaIds) {
            this.bugzillaIds(Arrays.asList(bugzillaIds));
            return this;
        }

        public final Collection<String> getCveIds() {
            if (this.cveIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cveIds;
        }

        public final void setCveIds(Collection<String> cveIds) {
            this.cveIds = PatchCVEIdListCopier.copy(cveIds);
        }

        @Override
        @Transient
        public final Builder cveIds(Collection<String> cveIds) {
            this.cveIds = PatchCVEIdListCopier.copy(cveIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cveIds(String ... cveIds) {
            this.cveIds(Arrays.asList(cveIds));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getEpoch() {
            return this.epoch;
        }

        public final void setEpoch(Integer epoch) {
            this.epoch = epoch;
        }

        @Override
        @Transient
        public final Builder epoch(Integer epoch) {
            this.epoch = epoch;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getRelease() {
            return this.release;
        }

        public final void setRelease(String release) {
            this.release = release;
        }

        @Override
        @Transient
        public final Builder release(String release) {
            this.release = release;
            return this;
        }

        public final String getArch() {
            return this.arch;
        }

        public final void setArch(String arch) {
            this.arch = arch;
        }

        @Override
        @Transient
        public final Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final String getRepository() {
            return this.repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        @Transient
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public Patch build() {
            return new Patch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Patch> {
        public Builder id(String var1);

        public Builder releaseDate(Instant var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder contentUrl(String var1);

        public Builder vendor(String var1);

        public Builder productFamily(String var1);

        public Builder product(String var1);

        public Builder classification(String var1);

        public Builder msrcSeverity(String var1);

        public Builder kbNumber(String var1);

        public Builder msrcNumber(String var1);

        public Builder language(String var1);

        public Builder advisoryIds(Collection<String> var1);

        public Builder advisoryIds(String ... var1);

        public Builder bugzillaIds(Collection<String> var1);

        public Builder bugzillaIds(String ... var1);

        public Builder cveIds(Collection<String> var1);

        public Builder cveIds(String ... var1);

        public Builder name(String var1);

        public Builder epoch(Integer var1);

        public Builder version(String var1);

        public Builder release(String var1);

        public Builder arch(String var1);

        public Builder severity(String var1);

        public Builder repository(String var1);
    }
}

