/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnlabelParameterVersionResponse extends SsmResponse implements
        ToCopyableBuilder<UnlabelParameterVersionResponse.Builder, UnlabelParameterVersionResponse> {
    private static final SdkField<List<String>> REMOVED_LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemovedLabels")
            .getter(getter(UnlabelParameterVersionResponse::removedLabels))
            .setter(setter(Builder::removedLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovedLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INVALID_LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InvalidLabels")
            .getter(getter(UnlabelParameterVersionResponse::invalidLabels))
            .setter(setter(Builder::invalidLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOVED_LABELS_FIELD,
            INVALID_LABELS_FIELD));

    private final List<String> removedLabels;

    private final List<String> invalidLabels;

    private UnlabelParameterVersionResponse(BuilderImpl builder) {
        super(builder);
        this.removedLabels = builder.removedLabels;
        this.invalidLabels = builder.invalidLabels;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemovedLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemovedLabels() {
        return removedLabels != null && !(removedLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all labels deleted from the parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemovedLabels} method.
     * </p>
     * 
     * @return A list of all labels deleted from the parameter.
     */
    public final List<String> removedLabels() {
        return removedLabels;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvalidLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvalidLabels() {
        return invalidLabels != null && !(invalidLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The labels that aren't attached to the given parameter version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvalidLabels} method.
     * </p>
     * 
     * @return The labels that aren't attached to the given parameter version.
     */
    public final List<String> invalidLabels() {
        return invalidLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRemovedLabels() ? removedLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInvalidLabels() ? invalidLabels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlabelParameterVersionResponse)) {
            return false;
        }
        UnlabelParameterVersionResponse other = (UnlabelParameterVersionResponse) obj;
        return hasRemovedLabels() == other.hasRemovedLabels() && Objects.equals(removedLabels(), other.removedLabels())
                && hasInvalidLabels() == other.hasInvalidLabels() && Objects.equals(invalidLabels(), other.invalidLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnlabelParameterVersionResponse")
                .add("RemovedLabels", hasRemovedLabels() ? removedLabels() : null)
                .add("InvalidLabels", hasInvalidLabels() ? invalidLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RemovedLabels":
            return Optional.ofNullable(clazz.cast(removedLabels()));
        case "InvalidLabels":
            return Optional.ofNullable(clazz.cast(invalidLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnlabelParameterVersionResponse, T> g) {
        return obj -> g.apply((UnlabelParameterVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, UnlabelParameterVersionResponse> {
        /**
         * <p>
         * A list of all labels deleted from the parameter.
         * </p>
         * 
         * @param removedLabels
         *        A list of all labels deleted from the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removedLabels(Collection<String> removedLabels);

        /**
         * <p>
         * A list of all labels deleted from the parameter.
         * </p>
         * 
         * @param removedLabels
         *        A list of all labels deleted from the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removedLabels(String... removedLabels);

        /**
         * <p>
         * The labels that aren't attached to the given parameter version.
         * </p>
         * 
         * @param invalidLabels
         *        The labels that aren't attached to the given parameter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidLabels(Collection<String> invalidLabels);

        /**
         * <p>
         * The labels that aren't attached to the given parameter version.
         * </p>
         * 
         * @param invalidLabels
         *        The labels that aren't attached to the given parameter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidLabels(String... invalidLabels);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<String> removedLabels = DefaultSdkAutoConstructList.getInstance();

        private List<String> invalidLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnlabelParameterVersionResponse model) {
            super(model);
            removedLabels(model.removedLabels);
            invalidLabels(model.invalidLabels);
        }

        public final Collection<String> getRemovedLabels() {
            if (removedLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return removedLabels;
        }

        public final void setRemovedLabels(Collection<String> removedLabels) {
            this.removedLabels = ParameterLabelListCopier.copy(removedLabels);
        }

        @Override
        @Transient
        public final Builder removedLabels(Collection<String> removedLabels) {
            this.removedLabels = ParameterLabelListCopier.copy(removedLabels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removedLabels(String... removedLabels) {
            removedLabels(Arrays.asList(removedLabels));
            return this;
        }

        public final Collection<String> getInvalidLabels() {
            if (invalidLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return invalidLabels;
        }

        public final void setInvalidLabels(Collection<String> invalidLabels) {
            this.invalidLabels = ParameterLabelListCopier.copy(invalidLabels);
        }

        @Override
        @Transient
        public final Builder invalidLabels(Collection<String> invalidLabels) {
            this.invalidLabels = ParameterLabelListCopier.copy(invalidLabels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder invalidLabels(String... invalidLabels) {
            invalidLabels(Arrays.asList(invalidLabels));
            return this;
        }

        @Override
        public UnlabelParameterVersionResponse build() {
            return new UnlabelParameterVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
