/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.internal.UserAgentUtils;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;

public class ListDeadLetterSourceQueuesPublisher
implements SdkPublisher<ListDeadLetterSourceQueuesResponse> {
    private final SqsAsyncClient client;
    private final ListDeadLetterSourceQueuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeadLetterSourceQueuesPublisher(SqsAsyncClient client, ListDeadLetterSourceQueuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeadLetterSourceQueuesPublisher(SqsAsyncClient client, ListDeadLetterSourceQueuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeadLetterSourceQueuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeadLetterSourceQueuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> queueUrls() {
        return this.flatMapIterable(response -> response.queueUrls());
    }

    private class ListDeadLetterSourceQueuesResponseFetcher
    implements AsyncPageFetcher<ListDeadLetterSourceQueuesResponse> {
        private ListDeadLetterSourceQueuesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeadLetterSourceQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeadLetterSourceQueuesResponse> nextPage(ListDeadLetterSourceQueuesResponse previousPage) {
            if (previousPage == null) {
                return ListDeadLetterSourceQueuesPublisher.this.client.listDeadLetterSourceQueues(ListDeadLetterSourceQueuesPublisher.this.firstRequest);
            }
            return ListDeadLetterSourceQueuesPublisher.this.client.listDeadLetterSourceQueues((ListDeadLetterSourceQueuesRequest)((Object)ListDeadLetterSourceQueuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

