/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.batchmanager.BatchOverrideConfiguration;
import software.amazon.awssdk.services.sqs.batchmanager.SqsAsyncBatchManager;
import software.amazon.awssdk.services.sqs.internal.batchmanager.ChangeMessageVisibilityBatchManager;
import software.amazon.awssdk.services.sqs.internal.batchmanager.DeleteMessageBatchManager;
import software.amazon.awssdk.services.sqs.internal.batchmanager.ReceiveMessageBatchManager;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchConfiguration;
import software.amazon.awssdk.services.sqs.internal.batchmanager.ResponseBatchConfiguration;
import software.amazon.awssdk.services.sqs.internal.batchmanager.SendMessageBatchManager;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultSqsAsyncBatchManager
implements SqsAsyncBatchManager {
    private final SqsAsyncClient client;
    private final SendMessageBatchManager sendMessageBatchManager;
    private final DeleteMessageBatchManager deleteMessageBatchManager;
    private final ChangeMessageVisibilityBatchManager changeMessageVisibilityBatchManager;
    private final ReceiveMessageBatchManager receiveMessageBatchManager;

    private DefaultSqsAsyncBatchManager(DefaultBuilder builder) {
        this.client = (SqsAsyncClient)Validate.notNull((Object)builder.client, (String)"client cannot be null", (Object[])new Object[0]);
        ScheduledExecutorService scheduledExecutor = (ScheduledExecutorService)Validate.notNull((Object)builder.scheduledExecutor, (String)"scheduledExecutor cannot be null", (Object[])new Object[0]);
        this.sendMessageBatchManager = new SendMessageBatchManager(RequestBatchConfiguration.builder(builder.overrideConfiguration).maxBatchBytesSize(262144).build(), scheduledExecutor, this.client);
        this.deleteMessageBatchManager = new DeleteMessageBatchManager(RequestBatchConfiguration.builder(builder.overrideConfiguration).build(), scheduledExecutor, this.client);
        this.changeMessageVisibilityBatchManager = new ChangeMessageVisibilityBatchManager(RequestBatchConfiguration.builder(builder.overrideConfiguration).build(), scheduledExecutor, this.client);
        this.receiveMessageBatchManager = new ReceiveMessageBatchManager(this.client, scheduledExecutor, ResponseBatchConfiguration.builder(builder.overrideConfiguration).build());
    }

    @Override
    public CompletableFuture<SendMessageResponse> sendMessage(SendMessageRequest request) {
        return this.sendMessageBatchManager.batchRequest(request);
    }

    @Override
    public CompletableFuture<DeleteMessageResponse> deleteMessage(DeleteMessageRequest request) {
        return this.deleteMessageBatchManager.batchRequest(request);
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityResponse> changeMessageVisibility(ChangeMessageVisibilityRequest request) {
        return this.changeMessageVisibilityBatchManager.batchRequest(request);
    }

    @Override
    public CompletableFuture<ReceiveMessageResponse> receiveMessage(ReceiveMessageRequest request) {
        return this.receiveMessageBatchManager.batchRequest(request);
    }

    public static SqsAsyncBatchManager.Builder builder() {
        return new DefaultBuilder();
    }

    public void close() {
        this.sendMessageBatchManager.close();
        this.deleteMessageBatchManager.close();
        this.changeMessageVisibilityBatchManager.close();
        this.receiveMessageBatchManager.close();
    }

    public static final class DefaultBuilder
    implements SqsAsyncBatchManager.Builder {
        private SqsAsyncClient client;
        private BatchOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService scheduledExecutor;

        private DefaultBuilder() {
        }

        @Override
        public SqsAsyncBatchManager.Builder overrideConfiguration(BatchOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public SqsAsyncBatchManager.Builder client(SqsAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public SqsAsyncBatchManager.Builder scheduledExecutor(ScheduledExecutorService scheduledExecutor) {
            this.scheduledExecutor = scheduledExecutor;
            return this;
        }

        @Override
        public SqsAsyncBatchManager build() {
            return new DefaultSqsAsyncBatchManager(this);
        }
    }
}

