/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMessageMoveTaskRequest extends SqsRequest implements
        ToCopyableBuilder<StartMessageMoveTaskRequest.Builder, StartMessageMoveTaskRequest> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(StartMessageMoveTaskRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(StartMessageMoveTaskRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()).build();

    private static final SdkField<Integer> MAX_NUMBER_OF_MESSAGES_PER_SECOND_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxNumberOfMessagesPerSecond")
            .getter(getter(StartMessageMoveTaskRequest::maxNumberOfMessagesPerSecond))
            .setter(setter(Builder::maxNumberOfMessagesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfMessagesPerSecond")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD,
            DESTINATION_ARN_FIELD, MAX_NUMBER_OF_MESSAGES_PER_SECOND_FIELD));

    private final String sourceArn;

    private final String destinationArn;

    private final Integer maxNumberOfMessagesPerSecond;

    private StartMessageMoveTaskRequest(BuilderImpl builder) {
        super(builder);
        this.sourceArn = builder.sourceArn;
        this.destinationArn = builder.destinationArn;
        this.maxNumberOfMessagesPerSecond = builder.maxNumberOfMessagesPerSecond;
    }

    /**
     * <p>
     * The ARN of the queue that contains the messages to be moved to another queue. Currently, only ARNs of dead-letter
     * queues (DLQs) whose sources are other Amazon SQS queues are accepted. DLQs whose sources are non-SQS queues, such
     * as Lambda or Amazon SNS topics, are not currently supported.
     * </p>
     * 
     * @return The ARN of the queue that contains the messages to be moved to another queue. Currently, only ARNs of
     *         dead-letter queues (DLQs) whose sources are other Amazon SQS queues are accepted. DLQs whose sources are
     *         non-SQS queues, such as Lambda or Amazon SNS topics, are not currently supported.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The ARN of the queue that receives the moved messages. You can use this field to specify the destination queue
     * where you would like to redrive messages. If this field is left blank, the messages will be redriven back to
     * their respective original source queues.
     * </p>
     * 
     * @return The ARN of the queue that receives the moved messages. You can use this field to specify the destination
     *         queue where you would like to redrive messages. If this field is left blank, the messages will be
     *         redriven back to their respective original source queues.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The number of messages to be moved per second (the message movement rate). You can use this field to define a
     * fixed message movement rate. The maximum value for messages per second is 500. If this field is left blank, the
     * system will optimize the rate based on the queue message backlog size, which may vary throughout the duration of
     * the message movement task.
     * </p>
     * 
     * @return The number of messages to be moved per second (the message movement rate). You can use this field to
     *         define a fixed message movement rate. The maximum value for messages per second is 500. If this field is
     *         left blank, the system will optimize the rate based on the queue message backlog size, which may vary
     *         throughout the duration of the message movement task.
     */
    public final Integer maxNumberOfMessagesPerSecond() {
        return maxNumberOfMessagesPerSecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxNumberOfMessagesPerSecond());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMessageMoveTaskRequest)) {
            return false;
        }
        StartMessageMoveTaskRequest other = (StartMessageMoveTaskRequest) obj;
        return Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(destinationArn(), other.destinationArn())
                && Objects.equals(maxNumberOfMessagesPerSecond(), other.maxNumberOfMessagesPerSecond());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMessageMoveTaskRequest").add("SourceArn", sourceArn())
                .add("DestinationArn", destinationArn()).add("MaxNumberOfMessagesPerSecond", maxNumberOfMessagesPerSecond())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "MaxNumberOfMessagesPerSecond":
            return Optional.ofNullable(clazz.cast(maxNumberOfMessagesPerSecond()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMessageMoveTaskRequest, T> g) {
        return obj -> g.apply((StartMessageMoveTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SqsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartMessageMoveTaskRequest> {
        /**
         * <p>
         * The ARN of the queue that contains the messages to be moved to another queue. Currently, only ARNs of
         * dead-letter queues (DLQs) whose sources are other Amazon SQS queues are accepted. DLQs whose sources are
         * non-SQS queues, such as Lambda or Amazon SNS topics, are not currently supported.
         * </p>
         * 
         * @param sourceArn
         *        The ARN of the queue that contains the messages to be moved to another queue. Currently, only ARNs of
         *        dead-letter queues (DLQs) whose sources are other Amazon SQS queues are accepted. DLQs whose sources
         *        are non-SQS queues, such as Lambda or Amazon SNS topics, are not currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The ARN of the queue that receives the moved messages. You can use this field to specify the destination
         * queue where you would like to redrive messages. If this field is left blank, the messages will be redriven
         * back to their respective original source queues.
         * </p>
         * 
         * @param destinationArn
         *        The ARN of the queue that receives the moved messages. You can use this field to specify the
         *        destination queue where you would like to redrive messages. If this field is left blank, the messages
         *        will be redriven back to their respective original source queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The number of messages to be moved per second (the message movement rate). You can use this field to define a
         * fixed message movement rate. The maximum value for messages per second is 500. If this field is left blank,
         * the system will optimize the rate based on the queue message backlog size, which may vary throughout the
         * duration of the message movement task.
         * </p>
         * 
         * @param maxNumberOfMessagesPerSecond
         *        The number of messages to be moved per second (the message movement rate). You can use this field to
         *        define a fixed message movement rate. The maximum value for messages per second is 500. If this field
         *        is left blank, the system will optimize the rate based on the queue message backlog size, which may
         *        vary throughout the duration of the message movement task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfMessagesPerSecond(Integer maxNumberOfMessagesPerSecond);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SqsRequest.BuilderImpl implements Builder {
        private String sourceArn;

        private String destinationArn;

        private Integer maxNumberOfMessagesPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMessageMoveTaskRequest model) {
            super(model);
            sourceArn(model.sourceArn);
            destinationArn(model.destinationArn);
            maxNumberOfMessagesPerSecond(model.maxNumberOfMessagesPerSecond);
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final Integer getMaxNumberOfMessagesPerSecond() {
            return maxNumberOfMessagesPerSecond;
        }

        public final void setMaxNumberOfMessagesPerSecond(Integer maxNumberOfMessagesPerSecond) {
            this.maxNumberOfMessagesPerSecond = maxNumberOfMessagesPerSecond;
        }

        @Override
        public final Builder maxNumberOfMessagesPerSecond(Integer maxNumberOfMessagesPerSecond) {
            this.maxNumberOfMessagesPerSecond = maxNumberOfMessagesPerSecond;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMessageMoveTaskRequest build() {
            return new StartMessageMoveTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
