/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.internal.UserAgentUtils;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;

public class ListDeadLetterSourceQueuesIterable
implements SdkIterable<ListDeadLetterSourceQueuesResponse> {
    private final SqsClient client;
    private final ListDeadLetterSourceQueuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeadLetterSourceQueuesIterable(SqsClient client, ListDeadLetterSourceQueuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeadLetterSourceQueuesResponseFetcher();
    }

    public Iterator<ListDeadLetterSourceQueuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> queueUrls() {
        Function<ListDeadLetterSourceQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.queueUrls() != null) {
                return response.queueUrls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeadLetterSourceQueuesResponseFetcher
    implements SyncPageFetcher<ListDeadLetterSourceQueuesResponse> {
        private ListDeadLetterSourceQueuesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeadLetterSourceQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeadLetterSourceQueuesResponse nextPage(ListDeadLetterSourceQueuesResponse previousPage) {
            if (previousPage == null) {
                return ListDeadLetterSourceQueuesIterable.this.client.listDeadLetterSourceQueues(ListDeadLetterSourceQueuesIterable.this.firstRequest);
            }
            return ListDeadLetterSourceQueuesIterable.this.client.listDeadLetterSourceQueues((ListDeadLetterSourceQueuesRequest)((Object)ListDeadLetterSourceQueuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

