/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.socialmessaging.SocialMessagingClient;
import software.amazon.awssdk.services.socialmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppMessageTemplatesResponse;
import software.amazon.awssdk.services.socialmessaging.model.TemplateSummary;

public class ListWhatsAppMessageTemplatesIterable
implements SdkIterable<ListWhatsAppMessageTemplatesResponse> {
    private final SocialMessagingClient client;
    private final ListWhatsAppMessageTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWhatsAppMessageTemplatesIterable(SocialMessagingClient client, ListWhatsAppMessageTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWhatsAppMessageTemplatesResponseFetcher();
    }

    public Iterator<ListWhatsAppMessageTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateSummary> templates() {
        Function<ListWhatsAppMessageTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templates() != null) {
                return response.templates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWhatsAppMessageTemplatesResponseFetcher
    implements SyncPageFetcher<ListWhatsAppMessageTemplatesResponse> {
        private ListWhatsAppMessageTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListWhatsAppMessageTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWhatsAppMessageTemplatesResponse nextPage(ListWhatsAppMessageTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListWhatsAppMessageTemplatesIterable.this.client.listWhatsAppMessageTemplates(ListWhatsAppMessageTemplatesIterable.this.firstRequest);
            }
            return ListWhatsAppMessageTemplatesIterable.this.client.listWhatsAppMessageTemplates((ListWhatsAppMessageTemplatesRequest)((Object)ListWhatsAppMessageTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

