/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.socialmessaging.SocialMessagingAsyncClient;
import software.amazon.awssdk.services.socialmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.socialmessaging.model.LinkedWhatsAppBusinessAccountSummary;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse;

public class ListLinkedWhatsAppBusinessAccountsPublisher
implements SdkPublisher<ListLinkedWhatsAppBusinessAccountsResponse> {
    private final SocialMessagingAsyncClient client;
    private final ListLinkedWhatsAppBusinessAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLinkedWhatsAppBusinessAccountsPublisher(SocialMessagingAsyncClient client, ListLinkedWhatsAppBusinessAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLinkedWhatsAppBusinessAccountsPublisher(SocialMessagingAsyncClient client, ListLinkedWhatsAppBusinessAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLinkedWhatsAppBusinessAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLinkedWhatsAppBusinessAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LinkedWhatsAppBusinessAccountSummary> linkedAccounts() {
        Function<ListLinkedWhatsAppBusinessAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.linkedAccounts() != null) {
                return response.linkedAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLinkedWhatsAppBusinessAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLinkedWhatsAppBusinessAccountsResponseFetcher
    implements AsyncPageFetcher<ListLinkedWhatsAppBusinessAccountsResponse> {
        private ListLinkedWhatsAppBusinessAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListLinkedWhatsAppBusinessAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLinkedWhatsAppBusinessAccountsResponse> nextPage(ListLinkedWhatsAppBusinessAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListLinkedWhatsAppBusinessAccountsPublisher.this.client.listLinkedWhatsAppBusinessAccounts(ListLinkedWhatsAppBusinessAccountsPublisher.this.firstRequest);
            }
            return ListLinkedWhatsAppBusinessAccountsPublisher.this.client.listLinkedWhatsAppBusinessAccounts((ListLinkedWhatsAppBusinessAccountsRequest)((Object)ListLinkedWhatsAppBusinessAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

