/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.MetaLibraryTemplateDefinition;
import software.amazon.awssdk.services.socialmessaging.model.MetaLibraryTemplatesListCopier;
import software.amazon.awssdk.services.socialmessaging.model.SocialMessagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWhatsAppTemplateLibraryResponse
extends SocialMessagingResponse
implements ToCopyableBuilder<Builder, ListWhatsAppTemplateLibraryResponse> {
    private static final SdkField<List<MetaLibraryTemplateDefinition>> META_LIBRARY_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metaLibraryTemplates").getter(ListWhatsAppTemplateLibraryResponse.getter(ListWhatsAppTemplateLibraryResponse::metaLibraryTemplates)).setter(ListWhatsAppTemplateLibraryResponse.setter(Builder::metaLibraryTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaLibraryTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetaLibraryTemplateDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWhatsAppTemplateLibraryResponse.getter(ListWhatsAppTemplateLibraryResponse::nextToken)).setter(ListWhatsAppTemplateLibraryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(META_LIBRARY_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWhatsAppTemplateLibraryResponse.memberNameToFieldInitializer();
    private final List<MetaLibraryTemplateDefinition> metaLibraryTemplates;
    private final String nextToken;

    private ListWhatsAppTemplateLibraryResponse(BuilderImpl builder) {
        super(builder);
        this.metaLibraryTemplates = builder.metaLibraryTemplates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetaLibraryTemplates() {
        return this.metaLibraryTemplates != null && !(this.metaLibraryTemplates instanceof SdkAutoConstructList);
    }

    public final List<MetaLibraryTemplateDefinition> metaLibraryTemplates() {
        return this.metaLibraryTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetaLibraryTemplates() ? this.metaLibraryTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWhatsAppTemplateLibraryResponse)) {
            return false;
        }
        ListWhatsAppTemplateLibraryResponse other = (ListWhatsAppTemplateLibraryResponse)((Object)obj);
        return this.hasMetaLibraryTemplates() == other.hasMetaLibraryTemplates() && Objects.equals(this.metaLibraryTemplates(), other.metaLibraryTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWhatsAppTemplateLibraryResponse").add("MetaLibraryTemplates", this.hasMetaLibraryTemplates() ? this.metaLibraryTemplates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metaLibraryTemplates": {
                return Optional.ofNullable(clazz.cast(this.metaLibraryTemplates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metaLibraryTemplates", META_LIBRARY_TEMPLATES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWhatsAppTemplateLibraryResponse, T> g) {
        return obj -> g.apply((ListWhatsAppTemplateLibraryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SocialMessagingResponse.BuilderImpl
    implements Builder {
        private List<MetaLibraryTemplateDefinition> metaLibraryTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWhatsAppTemplateLibraryResponse model) {
            super(model);
            this.metaLibraryTemplates(model.metaLibraryTemplates);
            this.nextToken(model.nextToken);
        }

        public final List<MetaLibraryTemplateDefinition.Builder> getMetaLibraryTemplates() {
            List<MetaLibraryTemplateDefinition.Builder> result = MetaLibraryTemplatesListCopier.copyToBuilder(this.metaLibraryTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetaLibraryTemplates(Collection<MetaLibraryTemplateDefinition.BuilderImpl> metaLibraryTemplates) {
            this.metaLibraryTemplates = MetaLibraryTemplatesListCopier.copyFromBuilder(metaLibraryTemplates);
        }

        @Override
        public final Builder metaLibraryTemplates(Collection<MetaLibraryTemplateDefinition> metaLibraryTemplates) {
            this.metaLibraryTemplates = MetaLibraryTemplatesListCopier.copy(metaLibraryTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metaLibraryTemplates(MetaLibraryTemplateDefinition ... metaLibraryTemplates) {
            this.metaLibraryTemplates(Arrays.asList(metaLibraryTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metaLibraryTemplates(Consumer<MetaLibraryTemplateDefinition.Builder> ... metaLibraryTemplates) {
            this.metaLibraryTemplates(Stream.of(metaLibraryTemplates).map(c -> (MetaLibraryTemplateDefinition)((MetaLibraryTemplateDefinition.Builder)MetaLibraryTemplateDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWhatsAppTemplateLibraryResponse build() {
            return new ListWhatsAppTemplateLibraryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SocialMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWhatsAppTemplateLibraryResponse> {
        public Builder metaLibraryTemplates(Collection<MetaLibraryTemplateDefinition> var1);

        public Builder metaLibraryTemplates(MetaLibraryTemplateDefinition ... var1);

        public Builder metaLibraryTemplates(Consumer<MetaLibraryTemplateDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

