/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.SocialMessagingResponse;
import software.amazon.awssdk.services.socialmessaging.model.TemplateSummary;
import software.amazon.awssdk.services.socialmessaging.model.TemplateSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWhatsAppMessageTemplatesResponse
extends SocialMessagingResponse
implements ToCopyableBuilder<Builder, ListWhatsAppMessageTemplatesResponse> {
    private static final SdkField<List<TemplateSummary>> TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templates").getter(ListWhatsAppMessageTemplatesResponse.getter(ListWhatsAppMessageTemplatesResponse::templates)).setter(ListWhatsAppMessageTemplatesResponse.setter(Builder::templates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWhatsAppMessageTemplatesResponse.getter(ListWhatsAppMessageTemplatesResponse::nextToken)).setter(ListWhatsAppMessageTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWhatsAppMessageTemplatesResponse.memberNameToFieldInitializer();
    private final List<TemplateSummary> templates;
    private final String nextToken;

    private ListWhatsAppMessageTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templates = builder.templates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTemplates() {
        return this.templates != null && !(this.templates instanceof SdkAutoConstructList);
    }

    public final List<TemplateSummary> templates() {
        return this.templates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplates() ? this.templates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWhatsAppMessageTemplatesResponse)) {
            return false;
        }
        ListWhatsAppMessageTemplatesResponse other = (ListWhatsAppMessageTemplatesResponse)((Object)obj);
        return this.hasTemplates() == other.hasTemplates() && Objects.equals(this.templates(), other.templates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWhatsAppMessageTemplatesResponse").add("Templates", this.hasTemplates() ? this.templates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templates": {
                return Optional.ofNullable(clazz.cast(this.templates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("templates", TEMPLATES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWhatsAppMessageTemplatesResponse, T> g) {
        return obj -> g.apply((ListWhatsAppMessageTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SocialMessagingResponse.BuilderImpl
    implements Builder {
        private List<TemplateSummary> templates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWhatsAppMessageTemplatesResponse model) {
            super(model);
            this.templates(model.templates);
            this.nextToken(model.nextToken);
        }

        public final List<TemplateSummary.Builder> getTemplates() {
            List<TemplateSummary.Builder> result = TemplateSummaryListCopier.copyToBuilder(this.templates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplates(Collection<TemplateSummary.BuilderImpl> templates) {
            this.templates = TemplateSummaryListCopier.copyFromBuilder(templates);
        }

        @Override
        public final Builder templates(Collection<TemplateSummary> templates) {
            this.templates = TemplateSummaryListCopier.copy(templates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(TemplateSummary ... templates) {
            this.templates(Arrays.asList(templates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(Consumer<TemplateSummary.Builder> ... templates) {
            this.templates(Stream.of(templates).map(c -> (TemplateSummary)((TemplateSummary.Builder)TemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWhatsAppMessageTemplatesResponse build() {
            return new ListWhatsAppMessageTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SocialMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWhatsAppMessageTemplatesResponse> {
        public Builder templates(Collection<TemplateSummary> var1);

        public Builder templates(TemplateSummary ... var1);

        public Builder templates(Consumer<TemplateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

