/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response for Publish action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishResponse extends SnsResponse implements ToCopyableBuilder<PublishResponse.Builder, PublishResponse> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(PublishResponse::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SequenceNumber").getter(getter(PublishResponse::sequenceNumber)).setter(setter(Builder::sequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            SEQUENCE_NUMBER_FIELD));

    private final String messageId;

    private final String sequenceNumber;

    private PublishResponse(BuilderImpl builder) {
        super(builder);
        this.messageId = builder.messageId;
        this.sequenceNumber = builder.sequenceNumber;
    }

    /**
     * <p>
     * Unique identifier assigned to the published message.
     * </p>
     * <p>
     * Length Constraint: Maximum 100 characters
     * </p>
     * 
     * @return Unique identifier assigned to the published message.</p>
     *         <p>
     *         Length Constraint: Maximum 100 characters
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * This response element applies only to FIFO (first-in-first-out) topics.
     * </p>
     * <p>
     * The sequence number is a large, non-consecutive number that Amazon SNS assigns to each message. The length of
     * <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for each
     * <code>MessageGroupId</code>.
     * </p>
     * 
     * @return This response element applies only to FIFO (first-in-first-out) topics. </p>
     *         <p>
     *         The sequence number is a large, non-consecutive number that Amazon SNS assigns to each message. The
     *         length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for
     *         each <code>MessageGroupId</code>.
     */
    public final String sequenceNumber() {
        return sequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishResponse)) {
            return false;
        }
        PublishResponse other = (PublishResponse) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(sequenceNumber(), other.sequenceNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishResponse").add("MessageId", messageId()).add("SequenceNumber", sequenceNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "SequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishResponse, T> g) {
        return obj -> g.apply((PublishResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PublishResponse> {
        /**
         * <p>
         * Unique identifier assigned to the published message.
         * </p>
         * <p>
         * Length Constraint: Maximum 100 characters
         * </p>
         * 
         * @param messageId
         *        Unique identifier assigned to the published message.</p>
         *        <p>
         *        Length Constraint: Maximum 100 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * This response element applies only to FIFO (first-in-first-out) topics.
         * </p>
         * <p>
         * The sequence number is a large, non-consecutive number that Amazon SNS assigns to each message. The length of
         * <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for each
         * <code>MessageGroupId</code>.
         * </p>
         * 
         * @param sequenceNumber
         *        This response element applies only to FIFO (first-in-first-out) topics. </p>
         *        <p>
         *        The sequence number is a large, non-consecutive number that Amazon SNS assigns to each message. The
         *        length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase
         *        for each <code>MessageGroupId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private String messageId;

        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishResponse model) {
            super(model);
            messageId(model.messageId);
            sequenceNumber(model.sequenceNumber);
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public PublishResponse build() {
            return new PublishResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
