/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowdevicemanagement.model.InstanceIdsListCopier;
import software.amazon.awssdk.services.snowdevicemanagement.model.SnowDeviceManagementRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeviceEc2InstancesRequest
extends SnowDeviceManagementRequest
implements ToCopyableBuilder<Builder, DescribeDeviceEc2InstancesRequest> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceIds").getter(DescribeDeviceEc2InstancesRequest.getter(DescribeDeviceEc2InstancesRequest::instanceIds)).setter(DescribeDeviceEc2InstancesRequest.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MANAGED_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedDeviceId").getter(DescribeDeviceEc2InstancesRequest.getter(DescribeDeviceEc2InstancesRequest::managedDeviceId)).setter(DescribeDeviceEc2InstancesRequest.setter(Builder::managedDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("managedDeviceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD, MANAGED_DEVICE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDeviceEc2InstancesRequest.memberNameToFieldInitializer();
    private final List<String> instanceIds;
    private final String managedDeviceId;

    private DescribeDeviceEc2InstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.managedDeviceId = builder.managedDeviceId;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> instanceIds() {
        return this.instanceIds;
    }

    public final String managedDeviceId() {
        return this.managedDeviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managedDeviceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceEc2InstancesRequest)) {
            return false;
        }
        DescribeDeviceEc2InstancesRequest other = (DescribeDeviceEc2InstancesRequest)((Object)obj);
        return this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds()) && Objects.equals(this.managedDeviceId(), other.managedDeviceId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeviceEc2InstancesRequest").add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).add("ManagedDeviceId", (Object)this.managedDeviceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "managedDeviceId": {
                return Optional.ofNullable(clazz.cast(this.managedDeviceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceIds", INSTANCE_IDS_FIELD);
        map.put("managedDeviceId", MANAGED_DEVICE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceEc2InstancesRequest, T> g) {
        return obj -> g.apply((DescribeDeviceEc2InstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowDeviceManagementRequest.BuilderImpl
    implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private String managedDeviceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceEc2InstancesRequest model) {
            super(model);
            this.instanceIds(model.instanceIds);
            this.managedDeviceId(model.managedDeviceId);
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsListCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final String getManagedDeviceId() {
            return this.managedDeviceId;
        }

        public final void setManagedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
        }

        @Override
        public final Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeviceEc2InstancesRequest build() {
            return new DescribeDeviceEc2InstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SnowDeviceManagementRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeviceEc2InstancesRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder managedDeviceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

