/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PhysicalConnectorType {
    RJ45("RJ45"),
    SFP_PLUS("SFP_PLUS"),
    QSFP("QSFP"),
    RJ45_2("RJ45_2"),
    WIFI("WIFI"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PhysicalConnectorType> VALUE_MAP;
    private final String value;

    private PhysicalConnectorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PhysicalConnectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PhysicalConnectorType> knownValues() {
        EnumSet<PhysicalConnectorType> knownValues = EnumSet.allOf(PhysicalConnectorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PhysicalConnectorType.class, PhysicalConnectorType::toString);
    }
}

