/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.ServiceName;
import software.amazon.awssdk.services.snowball.model.ServiceVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DependentService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DependentService> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(DependentService.getter(DependentService::serviceNameAsString)).setter(DependentService.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<ServiceVersion> SERVICE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceVersion").getter(DependentService.getter(DependentService::serviceVersion)).setter(DependentService.setter(Builder::serviceVersion)).constructor(ServiceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, SERVICE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DependentService.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final ServiceVersion serviceVersion;

    private DependentService(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceVersion = builder.serviceVersion;
    }

    public final ServiceName serviceName() {
        return ServiceName.fromValue(this.serviceName);
    }

    public final String serviceNameAsString() {
        return this.serviceName;
    }

    public final ServiceVersion serviceVersion() {
        return this.serviceVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DependentService)) {
            return false;
        }
        DependentService other = (DependentService)obj;
        return Objects.equals(this.serviceNameAsString(), other.serviceNameAsString()) && Objects.equals(this.serviceVersion(), other.serviceVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DependentService").add("ServiceName", (Object)this.serviceNameAsString()).add("ServiceVersion", (Object)this.serviceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceNameAsString()));
            }
            case "ServiceVersion": {
                return Optional.ofNullable(clazz.cast(this.serviceVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("ServiceVersion", SERVICE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DependentService, T> g) {
        return obj -> g.apply((DependentService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private ServiceVersion serviceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DependentService model) {
            this.serviceName(model.serviceName);
            this.serviceVersion(model.serviceVersion);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final ServiceVersion.Builder getServiceVersion() {
            return this.serviceVersion != null ? this.serviceVersion.toBuilder() : null;
        }

        public final void setServiceVersion(ServiceVersion.BuilderImpl serviceVersion) {
            this.serviceVersion = serviceVersion != null ? serviceVersion.build() : null;
        }

        @Override
        public final Builder serviceVersion(ServiceVersion serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public DependentService build() {
            return new DependentService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DependentService> {
        public Builder serviceName(String var1);

        public Builder serviceName(ServiceName var1);

        public Builder serviceVersion(ServiceVersion var1);

        default public Builder serviceVersion(Consumer<ServiceVersion.Builder> serviceVersion) {
            return this.serviceVersion((ServiceVersion)((ServiceVersion.Builder)ServiceVersion.builder().applyMutation(serviceVersion)).build());
        }
    }
}

