/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.snowball.SnowballAsyncClient;
import software.amazon.awssdk.services.snowball.SnowballServiceClientConfiguration;
import software.amazon.awssdk.services.snowball.internal.SnowballServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.snowball.model.CancelClusterRequest;
import software.amazon.awssdk.services.snowball.model.CancelClusterResponse;
import software.amazon.awssdk.services.snowball.model.CancelJobRequest;
import software.amazon.awssdk.services.snowball.model.CancelJobResponse;
import software.amazon.awssdk.services.snowball.model.ClusterLimitExceededException;
import software.amazon.awssdk.services.snowball.model.ConflictException;
import software.amazon.awssdk.services.snowball.model.CreateAddressRequest;
import software.amazon.awssdk.services.snowball.model.CreateAddressResponse;
import software.amazon.awssdk.services.snowball.model.CreateClusterRequest;
import software.amazon.awssdk.services.snowball.model.CreateClusterResponse;
import software.amazon.awssdk.services.snowball.model.CreateJobRequest;
import software.amazon.awssdk.services.snowball.model.CreateJobResponse;
import software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.CreateLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest;
import software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.snowball.model.DescribeClusterRequest;
import software.amazon.awssdk.services.snowball.model.DescribeClusterResponse;
import software.amazon.awssdk.services.snowball.model.DescribeJobRequest;
import software.amazon.awssdk.services.snowball.model.DescribeJobResponse;
import software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest;
import software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelResponse;
import software.amazon.awssdk.services.snowball.model.Ec2RequestFailedException;
import software.amazon.awssdk.services.snowball.model.GetJobManifestRequest;
import software.amazon.awssdk.services.snowball.model.GetJobManifestResponse;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageRequest;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse;
import software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest;
import software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesResponse;
import software.amazon.awssdk.services.snowball.model.InvalidAddressException;
import software.amazon.awssdk.services.snowball.model.InvalidInputCombinationException;
import software.amazon.awssdk.services.snowball.model.InvalidJobStateException;
import software.amazon.awssdk.services.snowball.model.InvalidNextTokenException;
import software.amazon.awssdk.services.snowball.model.InvalidResourceException;
import software.amazon.awssdk.services.snowball.model.KmsRequestFailedException;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListClustersRequest;
import software.amazon.awssdk.services.snowball.model.ListClustersResponse;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse;
import software.amazon.awssdk.services.snowball.model.ListJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsResponse;
import software.amazon.awssdk.services.snowball.model.ListServiceVersionsRequest;
import software.amazon.awssdk.services.snowball.model.ListServiceVersionsResponse;
import software.amazon.awssdk.services.snowball.model.ReturnShippingLabelAlreadyExistsException;
import software.amazon.awssdk.services.snowball.model.SnowballException;
import software.amazon.awssdk.services.snowball.model.UnsupportedAddressException;
import software.amazon.awssdk.services.snowball.model.UpdateClusterRequest;
import software.amazon.awssdk.services.snowball.model.UpdateClusterResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateResponse;
import software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.transform.CancelClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateAddressRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateLongTermPricingRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.CreateReturnShippingLabelRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeAddressesRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.DescribeReturnShippingLabelRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobManifestRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetJobUnlockCodeRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetSnowballUsageRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.GetSoftwareUpdatesRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClusterJobsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListCompatibleImagesRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListLongTermPricingRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListPickupLocationsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.ListServiceVersionsRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateJobShipmentStateRequestMarshaller;
import software.amazon.awssdk.services.snowball.transform.UpdateLongTermPricingRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSnowballAsyncClient
implements SnowballAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSnowballAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSnowballAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Snowball#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CancelClusterResponse> cancelCluster(CancelClusterRequest cancelClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, cancelClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$cancelCluster$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$cancelCluster$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelJobResponse> cancelJob(CancelJobRequest cancelJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, cancelJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$cancelJob$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$cancelJob$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAddressResponse> createAddress(CreateAddressRequest createAddressRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAddressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, createAddressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAddress");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAddressResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAddress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAddressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAddressRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$createAddress$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$createAddress$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$createCluster$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$createCluster$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, createJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$createJob$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$createJob$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLongTermPricingResponse> createLongTermPricing(CreateLongTermPricingRequest createLongTermPricingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLongTermPricingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, createLongTermPricingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLongTermPricing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLongTermPricingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLongTermPricing").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLongTermPricingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLongTermPricingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$createLongTermPricing$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$createLongTermPricing$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateReturnShippingLabelResponse> createReturnShippingLabel(CreateReturnShippingLabelRequest createReturnShippingLabelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReturnShippingLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, createReturnShippingLabelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReturnShippingLabel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReturnShippingLabelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReturnShippingLabel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateReturnShippingLabelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createReturnShippingLabelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$createReturnShippingLabel$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$createReturnShippingLabel$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAddressResponse> describeAddress(DescribeAddressRequest describeAddressRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAddressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, describeAddressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAddress");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAddressResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAddress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAddressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAddressRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$describeAddress$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$describeAddress$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAddressesResponse> describeAddresses(DescribeAddressesRequest describeAddressesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAddressesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, describeAddressesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAddresses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAddressesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAddresses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAddressesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAddressesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$describeAddresses$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$describeAddresses$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeClusterResponse> describeCluster(DescribeClusterRequest describeClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, describeClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$describeCluster$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$describeCluster$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeJobResponse> describeJob(DescribeJobRequest describeJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, describeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$describeJob$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$describeJob$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeReturnShippingLabelResponse> describeReturnShippingLabel(DescribeReturnShippingLabelRequest describeReturnShippingLabelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReturnShippingLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, describeReturnShippingLabelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReturnShippingLabel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReturnShippingLabelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReturnShippingLabel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeReturnShippingLabelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeReturnShippingLabelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$describeReturnShippingLabel$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$describeReturnShippingLabel$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJobManifestResponse> getJobManifest(GetJobManifestRequest getJobManifestRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobManifestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, getJobManifestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobManifest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobManifestResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobManifest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJobManifestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJobManifestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$getJobManifest$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$getJobManifest$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJobUnlockCodeResponse> getJobUnlockCode(GetJobUnlockCodeRequest getJobUnlockCodeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobUnlockCodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, getJobUnlockCodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobUnlockCode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobUnlockCodeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobUnlockCode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJobUnlockCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJobUnlockCodeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$getJobUnlockCode$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$getJobUnlockCode$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSnowballUsageResponse> getSnowballUsage(GetSnowballUsageRequest getSnowballUsageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSnowballUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, getSnowballUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSnowballUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSnowballUsageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSnowballUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSnowballUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSnowballUsageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$getSnowballUsage$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$getSnowballUsage$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSoftwareUpdatesResponse> getSoftwareUpdates(GetSoftwareUpdatesRequest getSoftwareUpdatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSoftwareUpdatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, getSoftwareUpdatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSoftwareUpdates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSoftwareUpdatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSoftwareUpdates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSoftwareUpdatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSoftwareUpdatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$getSoftwareUpdates$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$getSoftwareUpdates$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListClusterJobsResponse> listClusterJobs(ListClusterJobsRequest listClusterJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClusterJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, listClusterJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusterJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClusterJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusterJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListClusterJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listClusterJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$listClusterJobs$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$listClusterJobs$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, listClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClustersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listClustersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$listClusters$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$listClusters$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCompatibleImagesResponse> listCompatibleImages(ListCompatibleImagesRequest listCompatibleImagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCompatibleImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, listCompatibleImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCompatibleImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCompatibleImagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCompatibleImages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCompatibleImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCompatibleImagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$listCompatibleImages$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$listCompatibleImages$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$listJobs$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$listJobs$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLongTermPricingResponse> listLongTermPricing(ListLongTermPricingRequest listLongTermPricingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLongTermPricingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, listLongTermPricingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLongTermPricing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLongTermPricingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLongTermPricing").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLongTermPricingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLongTermPricingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$listLongTermPricing$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$listLongTermPricing$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPickupLocationsResponse> listPickupLocations(ListPickupLocationsRequest listPickupLocationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPickupLocationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, listPickupLocationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPickupLocations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPickupLocationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPickupLocations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPickupLocationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPickupLocationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$listPickupLocations$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$listPickupLocations$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListServiceVersionsResponse> listServiceVersions(ListServiceVersionsRequest listServiceVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServiceVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, listServiceVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListServiceVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listServiceVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$listServiceVersions$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$listServiceVersions$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateClusterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$updateCluster$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$updateCluster$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateJobResponse> updateJob(UpdateJobRequest updateJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, updateJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$updateJob$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$updateJob$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateJobShipmentStateResponse> updateJobShipmentState(UpdateJobShipmentStateRequest updateJobShipmentStateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateJobShipmentStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, updateJobShipmentStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobShipmentState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJobShipmentStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobShipmentState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateJobShipmentStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateJobShipmentStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$updateJobShipmentState$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$updateJobShipmentState$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLongTermPricingResponse> updateLongTermPricing(UpdateLongTermPricingRequest updateLongTermPricingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLongTermPricingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSnowballAsyncClient.resolveMetricPublishers(clientConfiguration, updateLongTermPricingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Snowball");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLongTermPricing");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLongTermPricingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "ReturnShippingLabelAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReturnShippingLabelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReturnShippingLabelAlreadyExistsException::builder).build());
                    }
                    case "UnsupportedAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedAddressException::builder).build());
                    }
                    case "Ec2RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("Ec2RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(Ec2RequestFailedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "KMSRequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("KMSRequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsRequestFailedException::builder).build());
                    }
                    case "InvalidAddressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAddressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidAddressException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceException::builder).build());
                    }
                    case "ClusterLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClusterLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClusterLimitExceededException::builder).build());
                    }
                    case "InvalidInputCombinationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputCombinationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLongTermPricing").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateLongTermPricingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLongTermPricingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSnowballAsyncClient.lambda$updateLongTermPricing$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSnowballAsyncClient.lambda$updateLongTermPricing$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final SnowballServiceClientConfiguration serviceClientConfiguration() {
        return new SnowballServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "snowball";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SnowballException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SnowballServiceClientConfigurationBuilder serviceConfigBuilder = new SnowballServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateLongTermPricing$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLongTermPricing$106(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLongTermPricingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateJobShipmentState$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJobShipmentState$102(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateJobShipmentStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateJob$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJob$98(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCluster$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCluster$94(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listServiceVersions$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceVersions$90(List metricPublishers, MetricCollector apiCallMetricCollector, ListServiceVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPickupLocations$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPickupLocations$86(List metricPublishers, MetricCollector apiCallMetricCollector, ListPickupLocationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLongTermPricing$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLongTermPricing$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListLongTermPricingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listJobs$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobs$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCompatibleImages$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCompatibleImages$74(List metricPublishers, MetricCollector apiCallMetricCollector, ListCompatibleImagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listClusters$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusters$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListClustersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listClusterJobs$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusterJobs$66(List metricPublishers, MetricCollector apiCallMetricCollector, ListClusterJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSoftwareUpdates$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSoftwareUpdates$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetSoftwareUpdatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSnowballUsage$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSnowballUsage$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetSnowballUsageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJobUnlockCode$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobUnlockCode$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetJobUnlockCodeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJobManifest$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobManifest$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetJobManifestResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeReturnShippingLabel$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReturnShippingLabel$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeReturnShippingLabelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeJob$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJob$42(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCluster$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCluster$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAddresses$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAddresses$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAddressesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAddress$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAddress$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAddressResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createReturnShippingLabel$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReturnShippingLabel$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateReturnShippingLabelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLongTermPricing$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLongTermPricing$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLongTermPricingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createJob$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJob$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCluster$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAddress$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAddress$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAddressResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelJob$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelJob$6(List metricPublishers, MetricCollector apiCallMetricCollector, CancelJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelCluster$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelCluster$2(List metricPublishers, MetricCollector apiCallMetricCollector, CancelClusterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

