/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerValidationStrategy {
    USERDATA("USERDATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerValidationStrategy> VALUE_MAP;
    private final String value;

    private ServerValidationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerValidationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerValidationStrategy> knownValues() {
        EnumSet<ServerValidationStrategy> knownValues = EnumSet.allOf(ServerValidationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerValidationStrategy.class, ServerValidationStrategy::toString);
    }
}

